/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.report;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.osdn.aoiro.AccountSettlement;
import net.osdn.aoiro.Util;
import net.osdn.aoiro.model.Account;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.AccountType;
import net.osdn.aoiro.model.Creditor;
import net.osdn.aoiro.model.Debtor;
import net.osdn.aoiro.model.JournalEntry;
import net.osdn.pdf_brewer.BrewerData;
import net.osdn.pdf_brewer.FontLoader;
import net.osdn.pdf_brewer.PdfBrewer;

public class GeneralLedger {
    private static final int ROWS = 50;
    private static final double ROW_HEIGHT = 5.0;
    private Set<AccountTitle> accountTitles;
    private List<JournalEntry> entries;
    private boolean isSoloProprietorship;
    private boolean showMonthlyTotal;
    private LocalDate openingDate;
    int financialYear;
    boolean isFromNewYearsDay;
    private List<String> pageData = new ArrayList<String>();
    private List<String> printData;
    private FontLoader fontLoader;
    private boolean bindingMarginEnabled = true;
    private boolean pageNumberEnabled = true;

    public GeneralLedger(Set<AccountTitle> accountTitles, List<JournalEntry> journalEntries, boolean isSoloProprietorship, boolean showMonthlyTotal) throws IOException {
        String line;
        this.accountTitles = new LinkedHashSet<AccountTitle>(accountTitles);
        this.accountTitles.remove(AccountTitle.INCOME_SUMMARY);
        this.accountTitles.add(AccountTitle.INCOME_SUMMARY);
        this.accountTitles.remove(AccountTitle.RETAINED_EARNINGS);
        this.accountTitles.add(AccountTitle.RETAINED_EARNINGS);
        this.accountTitles.remove(AccountTitle.PRETAX_INCOME);
        this.accountTitles.add(AccountTitle.PRETAX_INCOME);
        this.accountTitles.remove(AccountTitle.BALANCE);
        this.accountTitles.add(AccountTitle.BALANCE);
        this.entries = journalEntries;
        this.isSoloProprietorship = isSoloProprietorship;
        this.showMonthlyTotal = showMonthlyTotal;
        this.openingDate = AccountSettlement.getOpeningDate(journalEntries, isSoloProprietorship);
        InputStream in = this.getClass().getResourceAsStream("/templates/\u7dcf\u52d8\u5b9a\u5143\u5e33.pb");
        BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        while ((line = r.readLine()) != null) {
            this.pageData.add(line);
        }
        r.close();
        LocalDate closing = AccountSettlement.getClosingDate(this.entries, isSoloProprietorship);
        if (closing.getMonthValue() == 12 && closing.getDayOfMonth() == 31) {
            this.financialYear = closing.getYear();
            this.isFromNewYearsDay = true;
        } else {
            this.financialYear = closing.getYear() - 1;
            this.isFromNewYearsDay = false;
        }
        this.prepare();
    }

    public List<JournalEntry> getJournalEntries() {
        return this.entries;
    }

    protected void prepare() {
        int pageNumber = 0;
        AccountTitle currentAccountTitle = null;
        this.printData = new ArrayList<String>();
        if (this.bindingMarginEnabled) {
            this.printData.add("\\media A4");
            this.printData.add("\\line-style thin dot");
            this.printData.add("\\line 0 148.5 5 148.5");
        } else {
            this.printData.add("\\media 195 297");
        }
        for (AccountTitle accountTitle : this.accountTitles) {
            int restOfRows = 0;
            int currentRow = 0;
            String sign = "";
            long debtorTotal = 0L;
            long creditorTotal = 0L;
            long accountTitleTotal = 0L;
            long monthlyDebtorTotal = 0L;
            long monthlyCreditorTotal = 0L;
            List<JournalEntry> entries = this.getJournalEntriesByAccount(accountTitle);
            for (int j = 0; j < entries.size(); ++j) {
                JournalEntry entry = entries.get(j);
                int month = entry.getDate().getMonthValue();
                int day = entry.getDate().getDayOfMonth();
                int monthlyTotalMonth = -1;
                boolean isLastEntryInMonth = false;
                if (this.showMonthlyTotal) {
                    int n = monthlyTotalMonth = entry.isOpening(this.isSoloProprietorship, this.openingDate) ? 0 : month;
                    if (!entry.isClosing()) {
                        if (j + 1 == entries.size()) {
                            isLastEntryInMonth = true;
                        } else if (j + 1 < entries.size()) {
                            int nextEntryMonth;
                            JournalEntry nextEntry = entries.get(j + 1);
                            int n2 = nextEntryMonth = nextEntry.isOpening(this.isSoloProprietorship, this.openingDate) ? 0 : nextEntry.getDate().getMonthValue();
                            if (monthlyTotalMonth != nextEntryMonth) {
                                isLastEntryInMonth = true;
                            } else if (nextEntry.isClosing()) {
                                isLastEntryInMonth = true;
                            }
                        }
                    }
                }
                List<Account> accounts = this.getAccountsByAccountTitle(entry, accountTitle);
                List<Account> capitals = null;
                if (accountTitle.getDisplayName().equals("\u5143\u5165\u91d1") && accounts.size() >= 2) {
                    capitals = accounts.subList(1, accounts.size());
                    accounts = accounts.subList(0, 1);
                }
                for (int k = 0; k < accounts.size(); ++k) {
                    Account account = accounts.get(k);
                    List<Account> counterpartAccounts = this.getCounterpartAccounts(entry, account);
                    for (int l = 0; l < counterpartAccounts.size(); ++l) {
                        AccountType type;
                        Account counterpartAccount = counterpartAccounts.get(l);
                        if (this.showMonthlyTotal) {
                            if (account instanceof Debtor) {
                                monthlyDebtorTotal += counterpartAccount.getAmount();
                            }
                            if (account instanceof Creditor) {
                                monthlyCreditorTotal += counterpartAccount.getAmount();
                            }
                        }
                        boolean isCarriedForward = false;
                        boolean isLastInAccountTitle = l == counterpartAccounts.size() - 1 && k == accounts.size() - 1 && j == entries.size() - 1;
                        int rowsRequired = 1;
                        if (!isLastInAccountTitle && currentRow + 1 == 49) {
                            ++rowsRequired;
                            isCarriedForward = true;
                        }
                        if (rowsRequired > restOfRows || !accountTitle.equals(currentAccountTitle)) {
                            this.newPage(++pageNumber, account.getAccountTitle().getDisplayName());
                            restOfRows = 50;
                            currentRow = 0;
                            currentAccountTitle = account.getAccountTitle();
                            if (j != 0 || k != 0 || l != 0) {
                                this.carryForwardFromPreviousPage(currentRow, sign, accountTitleTotal);
                                ++currentRow;
                                --restOfRows;
                            }
                        }
                        if (account.getLedgerPageNumber() <= 0) {
                            account.setLedgerPageNumber(pageNumber);
                            if (capitals != null) {
                                for (Account capital : capitals) {
                                    capital.setLedgerPageNumber(pageNumber);
                                }
                            }
                        }
                        this.printData.add("\t\t\\box " + String.format("0 %.2f -0 %.2f", (double)currentRow * 5.0, 5.0));
                        this.printData.add("\t\t\\font serif 10");
                        this.printData.add("\t\t\t\\box " + String.format("0 0 6 %.2f", 5.0));
                        this.printData.add("\t\t\t\\align center right");
                        this.printData.add("\t\t\t\\text " + month);
                        this.printData.add("\t\t\t\\box " + String.format("8 0 6.2 %.2f", 5.0));
                        this.printData.add("\t\t\t\\align center right");
                        this.printData.add("\t\t\t\\text " + day);
                        this.printData.add("\t\t\\box " + String.format("17.5 %.2f 49.5 %.2f", (double)currentRow * 5.0, 5.0));
                        this.printData.add("\t\t\\font serif 9");
                        this.printData.add("\t\t\\align center left");
                        if (this.isSoloProprietorship && entry.isOpening(this.isSoloProprietorship, this.openingDate) && !account.getAccountTitle().getDisplayName().equals("\u5143\u5165\u91d1")) {
                            this.printData.add("\t\t\\text \u5143\u5165\u91d1");
                            if (!(entry.isClosing() || entry.getDescription().isBlank() || entry.getDescription().equals("\u5143\u5165\u91d1"))) {
                                this.printData.add("\t\t\\font serif 6");
                                this.printData.add("\t\t\\text  / " + entry.getDescription());
                            }
                        } else if (!this.isSoloProprietorship && entry.isOpening(this.isSoloProprietorship, this.openingDate)) {
                            this.printData.add("\t\t\\text " + entry.getDescription());
                        } else {
                            this.printData.add("\t\t\\text " + counterpartAccount.getAccountTitle().getDisplayName());
                            if (!(entry.isClosing() || entry.getDescription().isBlank() || entry.getDescription().equals(account.getAccountTitle().getDisplayName()) || entry.getDescription().equals(counterpartAccount.getAccountTitle().getDisplayName()))) {
                                this.printData.add("\t\t\\font serif 6");
                                this.printData.add("\t\t\\text  / " + entry.getDescription());
                            }
                        }
                        if (account.getJournalPageNumber() >= 1) {
                            this.printData.add("\t\t\\box " + String.format("67 %.2f 8 %.2f", (double)currentRow * 5.0, 5.0));
                            this.printData.add("\t\t\\font serif 10");
                            this.printData.add("\t\t\\align center");
                            this.printData.add("\t\t\\text " + account.getJournalPageNumber());
                        }
                        if (account.getAccountTitle().getDisplayName().equals("\u5143\u5165\u91d1")) {
                            if (counterpartAccount instanceof Creditor) {
                                this.printData.add("\t\t\\box " + String.format("75 %.2f 25 %.2f", (double)currentRow * 5.0, 5.0));
                                this.printData.add("\t\t\\font serif 10");
                                this.printData.add("\t\t\\align center right");
                                this.printData.add("\t\t\\text " + String.format("%,d", counterpartAccount.getAmount()));
                                accountTitleTotal = account.getAccountTitle().getType().getNormalBalance() == Debtor.class ? (accountTitleTotal += counterpartAccount.getAmount()) : (accountTitleTotal -= counterpartAccount.getAmount());
                                debtorTotal += counterpartAccount.getAmount();
                            }
                            if (counterpartAccount instanceof Debtor) {
                                this.printData.add("\t\t\\box " + String.format("105 %.2f 25 %.2f", (double)currentRow * 5.0, 5.0));
                                this.printData.add("\t\t\\font serif 10");
                                this.printData.add("\t\t\\align center right");
                                this.printData.add("\t\t\\text " + String.format("%,d", counterpartAccount.getAmount()));
                                accountTitleTotal = account.getAccountTitle().getType().getNormalBalance() == Creditor.class ? (accountTitleTotal += counterpartAccount.getAmount()) : (accountTitleTotal -= counterpartAccount.getAmount());
                                creditorTotal += counterpartAccount.getAmount();
                            }
                        } else {
                            if (account instanceof Debtor) {
                                this.printData.add("\t\t\\box " + String.format("75 %.2f 25 %.2f", (double)currentRow * 5.0, 5.0));
                                this.printData.add("\t\t\\font serif 10");
                                this.printData.add("\t\t\\align center right");
                                this.printData.add("\t\t\\text " + String.format("%,d", counterpartAccount.getAmount()));
                                accountTitleTotal = account.getAccountTitle().getType().getNormalBalance() == Debtor.class ? (accountTitleTotal += counterpartAccount.getAmount()) : (accountTitleTotal -= counterpartAccount.getAmount());
                                debtorTotal += counterpartAccount.getAmount();
                            }
                            if (account instanceof Creditor) {
                                this.printData.add("\t\t\\box " + String.format("105 %.2f 25 %.2f", (double)currentRow * 5.0, 5.0));
                                this.printData.add("\t\t\\font serif 10");
                                this.printData.add("\t\t\\align center right");
                                this.printData.add("\t\t\\text " + String.format("%,d", counterpartAccount.getAmount()));
                                accountTitleTotal = account.getAccountTitle().getType().getNormalBalance() == Creditor.class ? (accountTitleTotal += counterpartAccount.getAmount()) : (accountTitleTotal -= counterpartAccount.getAmount());
                                creditorTotal += counterpartAccount.getAmount();
                            }
                        }
                        if ((type = account.getAccountTitle().getType()).getNormalBalance() == Debtor.class) {
                            String string = sign = accountTitleTotal >= 0L ? "\u501f" : "\u8cb8";
                        }
                        if (type.getNormalBalance() == Creditor.class) {
                            sign = accountTitleTotal >= 0L ? "\u8cb8" : "\u501f";
                        }
                        this.printData.add("\t\t\\box " + String.format("135 %.2f 8 %.2f", (double)currentRow * 5.0, 5.0));
                        this.printData.add("\t\t\\font serif 10");
                        this.printData.add("\t\t\\align center");
                        this.printData.add("\t\t\\text " + sign);
                        this.printData.add("\t\t\\box " + String.format("143 %.2f 27 %.2f", (double)currentRow * 5.0, 5.0));
                        this.printData.add("\t\t\\font serif 10");
                        this.printData.add("\t\t\\align center right");
                        this.printData.add("\t\t\\text " + String.format("%,d", Math.abs(accountTitleTotal)));
                        if (isCarriedForward) {
                            this.carryForwardToNextPage(currentRow + 1, sign, accountTitleTotal);
                        }
                        currentRow += rowsRequired;
                        restOfRows -= rowsRequired;
                        if (!this.showMonthlyTotal || !isLastEntryInMonth || k + 1 != accounts.size() || l + 1 != counterpartAccounts.size()) continue;
                        int emptyRows = 49 - currentRow - (isLastInAccountTitle ? 0 : 1);
                        if (emptyRows < 0) {
                            emptyRows = 0;
                        }
                        if (emptyRows > 2 || isCarriedForward) {
                            emptyRows = 2;
                        }
                        rowsRequired = 1 + emptyRows;
                        if (!isLastInAccountTitle && currentRow + emptyRows + 1 == 49) {
                            ++rowsRequired;
                            isCarriedForward = true;
                        } else {
                            isCarriedForward = false;
                        }
                        if (rowsRequired > restOfRows) {
                            this.newPage(++pageNumber, account.getAccountTitle().getDisplayName());
                            restOfRows = 50;
                            currentRow = 0;
                            if (j != 0 || k != 0 || l != 0) {
                                this.carryForwardFromPreviousPage(currentRow, sign, accountTitleTotal);
                                ++currentRow;
                                --restOfRows;
                            }
                        }
                        this.printData.add("\t\t\\box " + String.format("16 %.2f 49 %.2f", (double)currentRow * 5.0, 5.0));
                        this.printData.add("\t\t\\font serif 10 bold");
                        this.printData.add("\t\t\\align center right");
                        if (monthlyTotalMonth == 0) {
                            this.printData.add("\t\t\\text \u524d\u671f\u7e70\u8d8a\u8a08");
                        } else {
                            this.printData.add("\t\t\\text " + month + "\u6708\u8a08");
                        }
                        this.printData.add("\t\t\\box " + String.format("0 %.2f -0 %.2f", (double)currentRow * 5.0, 5.5));
                        this.printData.add("\t\t\\line-style medium solid");
                        this.printData.add("\t\t\\line 75.325 0 134.675 0");
                        this.printData.add("\t\t\\box " + String.format("75 %.2f 25 %.2f", (double)currentRow * 5.0, 5.0));
                        this.printData.add("\t\t\\font serif 10.5 bold");
                        this.printData.add("\t\t\\align center right");
                        this.printData.add("\t\t\\text " + String.format("%,d", monthlyDebtorTotal));
                        this.printData.add("\t\t\\box " + String.format("105 %.2f 25 %.2f", (double)currentRow * 5.0, 5.0));
                        this.printData.add("\t\t\\font serif 10.5 bold");
                        this.printData.add("\t\t\\align center right");
                        this.printData.add("\t\t\\text " + String.format("%,d", monthlyCreditorTotal));
                        monthlyDebtorTotal = 0L;
                        monthlyCreditorTotal = 0L;
                        if (isCarriedForward) {
                            this.carryForwardToNextPage(currentRow + emptyRows + 1, sign, accountTitleTotal);
                        }
                        currentRow += rowsRequired;
                        restOfRows -= rowsRequired;
                    }
                }
            }
            if (entries.size() <= 0 || !entries.get(entries.size() - 1).isClosing()) continue;
            this.printData.add("\t\t\\box " + String.format("0 %.2f -0 %.2f", (double)currentRow * 5.0, 5.5));
            this.printData.add("\t\t\\line-style medium solid");
            this.printData.add("\t\t\\line 75.325 0 134.675 0");
            this.printData.add("\t\t\\line 0.125 -0.5 15.675 -0.5");
            this.printData.add("\t\t\\line 0.125 -0.0 15.675 -0.0");
            this.printData.add("\t\t\\line 75.325 -0.5 134.675 -0.5");
            this.printData.add("\t\t\\line 75.325 -0.0 134.675 -0.0");
            this.printData.add("\t\t\\box " + String.format("75 %.2f 25 %.2f", (double)currentRow * 5.0, 5.0));
            this.printData.add("\t\t\\font serif 10");
            this.printData.add("\t\t\\align center right");
            this.printData.add("\t\t\\text " + String.format("%,d", debtorTotal));
            this.printData.add("\t\t\\box " + String.format("105 %.2f 25 %.2f", (double)currentRow * 5.0, 5.0));
            this.printData.add("\t\t\\font serif 10");
            this.printData.add("\t\t\\align center right");
            this.printData.add("\t\t\\text " + String.format("%,d", creditorTotal));
        }
    }

    private void newPage(int pageNumber, String accountTitleDisplayName) {
        if (pageNumber >= 2) {
            this.printData.add("\\new-page");
        }
        if (!this.bindingMarginEnabled) {
            this.printData.add("\\box 10 0 -10 -10");
            this.printData.addAll(this.pageData);
            if (this.pageNumberEnabled) {
                if (pageNumber % 2 == 1) {
                    this.printData.add("\t\\box 0 0 -3 22");
                    this.printData.add("\t\\font serif 10.5");
                    this.printData.add("\t\\align bottom right");
                    this.printData.add("\t\\text " + pageNumber);
                } else {
                    this.printData.add("\t\\box 3 0 10 22");
                    this.printData.add("\t\\font serif 10.5");
                    this.printData.add("\t\\align bottom left");
                    this.printData.add("\t\\text " + pageNumber);
                }
            }
        } else if (pageNumber % 2 == 1) {
            this.printData.add("\\box 15 0 0 0");
            this.printData.add("\\line-style thin dot");
            this.printData.add("\\line 0 0 0 -0");
            this.printData.add("\\box 25 0 -10 -10");
            this.printData.addAll(this.pageData);
            if (this.pageNumberEnabled) {
                this.printData.add("\t\\box 0 0 -3 22");
                this.printData.add("\t\\font serif 10.5");
                this.printData.add("\t\\align bottom right");
                this.printData.add("\t\\text " + pageNumber);
            }
        } else {
            this.printData.add("\\box 0 0 -15 0");
            this.printData.add("\\line-style thin dot");
            this.printData.add("\\line -0 0 -0 -0");
            this.printData.add("\\box 10 0 -25 -10");
            this.printData.addAll(this.pageData);
            if (this.pageNumberEnabled) {
                this.printData.add("\t\\box 3 0 10 22");
                this.printData.add("\t\\font serif 10.5");
                this.printData.add("\t\\align bottom left");
                this.printData.add("\t\\text " + pageNumber);
            }
        }
        this.printData.add("\t\\box 0 16 -0 9");
        this.printData.add("\t\\font serif 14");
        this.printData.add("\t\\align center");
        this.printData.add("\t\\text " + accountTitleDisplayName);
        if (this.isFromNewYearsDay) {
            this.printData.add("\t\\box 0 25 14.5 6");
            this.printData.add("\t\\align center right");
            this.printData.add("\t\\font sans-serif 8");
            this.printData.add("\t\\text \u5e74");
            this.printData.add("\t\\box 0 25 10.5 6");
            this.printData.add("\t\\font serif 10");
            this.printData.add("\t\\align center right");
            this.printData.add("\t\\text " + this.financialYear);
        } else {
            this.printData.add("\t\\box 0 25 14.7 6");
            this.printData.add("\t\\align center right");
            this.printData.add("\t\\font sans-serif 8");
            this.printData.add("\t\\text \u5e74\u5ea6");
            this.printData.add("\t\\box 0 25 8.6 6");
            this.printData.add("\t\\font serif 10");
            this.printData.add("\t\\align center right");
            this.printData.add("\t\\text " + this.financialYear);
        }
        this.printData.add("\t\\box 0 37 -0 -0");
    }

    private void carryForwardFromPreviousPage(int currentRow, String sign, long accountTitleTotal) {
        this.printData.add("\t\t\\box " + String.format("16 %.2f 49 %.2f", (double)currentRow * 5.0, 5.0));
        this.printData.add("\t\t\\font serif 10");
        this.printData.add("\t\t\\align center right");
        this.printData.add("\t\t\\text \u524d\u9801\u7e70\u8d8a");
        this.printData.add("\t\t\\box " + String.format("135 %.2f 8 %.2f", (double)currentRow * 5.0, 5.0));
        this.printData.add("\t\t\\font serif 10");
        this.printData.add("\t\t\\align center");
        this.printData.add("\t\t\\text " + sign);
        this.printData.add("\t\t\\box " + String.format("143 %.2f 27 %.2f", (double)currentRow * 5.0, 5.0));
        this.printData.add("\t\t\\font serif 10");
        this.printData.add("\t\t\\align center right");
        this.printData.add("\t\t\\text " + String.format("%,d", Math.abs(accountTitleTotal)));
    }

    private void carryForwardToNextPage(int row, String sign, long accountTitleTotal) {
        this.printData.add("\t\t\\box " + String.format("16 %.2f 49 %.2f", (double)row * 5.0, 5.0));
        this.printData.add("\t\t\\font serif 10");
        this.printData.add("\t\t\\align center right");
        this.printData.add("\t\t\\text \u6b21\u9801\u7e70\u8d8a");
        this.printData.add("\t\t\\box " + String.format("135 %.2f 8 %.2f", (double)row * 5.0, 5.0));
        this.printData.add("\t\t\\font serif 10");
        this.printData.add("\t\t\\align center");
        this.printData.add("\t\t\\text " + sign);
        this.printData.add("\t\t\\box " + String.format("143 %.2f 27 %.2f", (double)row * 5.0, 5.0));
        this.printData.add("\t\t\\font serif 10");
        this.printData.add("\t\t\\align center right");
        this.printData.add("\t\t\\text " + String.format("%,d", Math.abs(accountTitleTotal)));
    }

    public List<Account> getAccountsByAccountTitle(JournalEntry entry, AccountTitle accountTitle) {
        int k;
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (k = 0; k < entry.getDebtors().size(); ++k) {
            Debtor debtor = entry.getDebtors().get(k);
            if (!debtor.getAccountTitle().equals(accountTitle)) continue;
            accounts.add(debtor);
        }
        for (k = 0; k < entry.getCreditors().size(); ++k) {
            Creditor creditor = entry.getCreditors().get(k);
            if (!creditor.getAccountTitle().equals(accountTitle)) continue;
            accounts.add(creditor);
        }
        return accounts;
    }

    public List<Account> getCounterpartAccounts(JournalEntry entry, Account account) {
        ArrayList<Account> counterpartAccounts = new ArrayList<Account>();
        boolean isCounterpartClosingAccount = false;
        if (account instanceof Debtor) {
            if (entry.getCreditors().size() == 1 && entry.getCreditors().get(0).getAccountTitle().isClosing()) {
                isCounterpartClosingAccount = true;
            }
        } else if (account instanceof Creditor && entry.getDebtors().size() == 1 && entry.getDebtors().get(0).getAccountTitle().isClosing()) {
            isCounterpartClosingAccount = true;
        }
        if (isCounterpartClosingAccount) {
            if (account instanceof Debtor) {
                counterpartAccounts.add(new Creditor(entry.getCreditors().get(0).getAccountTitle(), account.getAmount()));
            } else if (account instanceof Creditor) {
                counterpartAccounts.add(new Debtor(entry.getDebtors().get(0).getAccountTitle(), account.getAmount()));
            }
        } else if (account.getAccountTitle().getDisplayName().equals("\u5143\u5165\u91d1")) {
            for (Debtor debtor : entry.getDebtors()) {
                if (debtor.getAccountTitle().getDisplayName().equals("\u5143\u5165\u91d1")) continue;
                counterpartAccounts.add(debtor);
            }
            for (Creditor creditor : entry.getCreditors()) {
                if (creditor.getAccountTitle().getDisplayName().equals("\u5143\u5165\u91d1")) continue;
                counterpartAccounts.add(creditor);
            }
            if (counterpartAccounts.size() == 0) {
                for (Debtor debtor : entry.getDebtors()) {
                    counterpartAccounts.add(debtor);
                }
                for (Creditor creditor : entry.getCreditors()) {
                    counterpartAccounts.add(creditor);
                }
            }
        } else if (account.getAccountTitle().isClosing()) {
            if (account instanceof Debtor) {
                if (entry.getDebtors().size() == 1) {
                    counterpartAccounts.addAll(entry.getCreditors());
                } else {
                    counterpartAccounts.add(new Creditor(AccountTitle.SUNDRIES, account.getAmount()));
                }
            } else if (account instanceof Creditor) {
                if (entry.getCreditors().size() == 1) {
                    counterpartAccounts.addAll(entry.getDebtors());
                } else {
                    counterpartAccounts.add(new Debtor(AccountTitle.SUNDRIES, account.getAmount()));
                }
            }
        } else if (account instanceof Debtor) {
            if (entry.getCreditors().size() == 1) {
                counterpartAccounts.add(new Creditor(entry.getCreditors().get(0).getAccountTitle(), account.getAmount()));
            } else {
                counterpartAccounts.add(new Creditor(AccountTitle.SUNDRIES, account.getAmount()));
            }
        } else if (account instanceof Creditor) {
            if (entry.getDebtors().size() == 1) {
                counterpartAccounts.add(new Debtor(entry.getDebtors().get(0).getAccountTitle(), account.getAmount()));
            } else {
                counterpartAccounts.add(new Debtor(AccountTitle.SUNDRIES, account.getAmount()));
            }
        }
        return counterpartAccounts;
    }

    public void setFontLoader(FontLoader fontLoader) {
        this.fontLoader = fontLoader;
    }

    public void setBindingMarginEnabled(boolean enabled) {
        this.bindingMarginEnabled = enabled;
    }

    public void setPageNumberEnabled(boolean enabled) {
        this.pageNumberEnabled = enabled;
    }

    public void writeTo(Path path) throws IOException {
        this.prepare();
        PdfBrewer brewer = this.fontLoader != null ? new PdfBrewer(this.fontLoader) : new PdfBrewer();
        brewer.setCreator(Util.getPdfCreator());
        BrewerData pb = new BrewerData(this.printData, brewer.getFontLoader());
        brewer.setTitle("\u7dcf\u52d8\u5b9a\u5143\u5e33");
        brewer.process(pb);
        brewer.save(path);
        brewer.close();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.prepare();
        PdfBrewer brewer = this.fontLoader != null ? new PdfBrewer(this.fontLoader) : new PdfBrewer();
        brewer.setCreator(Util.getPdfCreator());
        BrewerData pb = new BrewerData(this.printData, brewer.getFontLoader());
        brewer.setTitle("\u7dcf\u52d8\u5b9a\u5143\u5e33");
        brewer.process(pb);
        brewer.save(out);
        brewer.close();
    }

    protected List<JournalEntry> getJournalEntriesByAccount(AccountTitle accountTitle) {
        ArrayList<JournalEntry> entriesByAccount = new ArrayList<JournalEntry>();
        if (accountTitle != null) {
            block0: for (JournalEntry entry : this.entries) {
                for (Debtor debtor : entry.getDebtors()) {
                    if (!accountTitle.equals(debtor.getAccountTitle())) continue;
                    entriesByAccount.add(entry);
                    continue block0;
                }
                for (Creditor creditor : entry.getCreditors()) {
                    if (!accountTitle.equals(creditor.getAccountTitle())) continue;
                    entriesByAccount.add(entry);
                    continue block0;
                }
            }
        }
        return entriesByAccount;
    }
}

