/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.aoiro.report.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osdn.aoiro.loader.yaml.YamlBeansUtil;
import net.osdn.aoiro.model.AccountTitle;
import net.osdn.aoiro.model.Amount;
import net.osdn.aoiro.model.Node;

public class ProfitAndLossLayout {
    private Node<Map.Entry<List<AccountTitle>, Amount>> root = new Node(-1, "\u640d\u76ca\u8a08\u7b97\u66f8");
    private Set<String> signReversedNames = new LinkedHashSet<String>();
    private Set<String> alwaysShownNames = new LinkedHashSet<String>();
    private Set<String> alwaysHiddenNames = new LinkedHashSet<String>();
    private Set<String> hiddenNamesIfZero = new LinkedHashSet<String>();
    private Set<AccountTitle> salesAccountTitles = null;
    private Set<AccountTitle> houseworkSalesAccountTitles = null;
    private Set<AccountTitle> miscellaneousSalesAccountTitles = null;
    private Set<AccountTitle> purchaseAccountTitles = null;

    public Node<Map.Entry<List<AccountTitle>, Amount>> getRoot() {
        return this.root;
    }

    public Set<String> getSignReversedNames() {
        return this.signReversedNames;
    }

    public Set<String> getAlwaysShownNames() {
        return this.alwaysShownNames;
    }

    public Set<String> getAlwaysHiddenNames() {
        return this.alwaysHiddenNames;
    }

    public Set<String> getHiddenNamesIfZero() {
        return this.hiddenNamesIfZero;
    }

    public Set<AccountTitle> getSalesAccountTitles() {
        if (this.salesAccountTitles == null) {
            this.createAccountTitlesForMonthly();
        }
        return this.salesAccountTitles;
    }

    public Set<AccountTitle> getHouseworkSalesAccountTitles() {
        if (this.houseworkSalesAccountTitles == null) {
            this.createAccountTitlesForMonthly();
        }
        return this.houseworkSalesAccountTitles;
    }

    public Set<AccountTitle> getMiscellaneousSalesAccountTitles() {
        if (this.miscellaneousSalesAccountTitles == null) {
            this.createAccountTitlesForMonthly();
        }
        return this.miscellaneousSalesAccountTitles;
    }

    public Set<AccountTitle> getPurchaseAccountTitles() {
        if (this.purchaseAccountTitles == null) {
            this.createAccountTitlesForMonthly();
        }
        return this.purchaseAccountTitles;
    }

    private void createAccountTitlesForMonthly() {
        this.salesAccountTitles = new LinkedHashSet<AccountTitle>();
        this.houseworkSalesAccountTitles = new LinkedHashSet<AccountTitle>();
        this.miscellaneousSalesAccountTitles = new LinkedHashSet<AccountTitle>();
        this.purchaseAccountTitles = new LinkedHashSet<AccountTitle>();
        List<Node<Map.Entry<List<AccountTitle>, Amount>>> list = this.flatten(this.getRoot());
        for (Node<Map.Entry<List<AccountTitle>, Amount>> node : list) {
            String name = node.getName();
            List<AccountTitle> accountTitles = node.getValue().getKey();
            ArrayList<String> accountTitleDisplayNames = new ArrayList<String>();
            for (AccountTitle accountTitle : accountTitles) {
                accountTitleDisplayNames.add(accountTitle.getDisplayName());
            }
            if (name.equals("\u58f2\u4e0a") || name.equals("\u58f2\u4e0a\u91d1\u984d") || name.equals("\u58f2\u4e0a\u9ad8") || accountTitleDisplayNames.contains("\u58f2\u4e0a")) {
                this.salesAccountTitles.addAll(accountTitles);
                continue;
            }
            if (name.equals("\u5bb6\u4e8b\u6d88\u8cbb\u7b49") || accountTitleDisplayNames.contains("\u5bb6\u4e8b\u6d88\u8cbb\u7b49")) {
                this.houseworkSalesAccountTitles.addAll(accountTitles);
                continue;
            }
            if (name.equals("\u96d1\u53ce\u5165") || accountTitleDisplayNames.contains("\u96d1\u53ce\u5165")) {
                this.miscellaneousSalesAccountTitles.addAll(accountTitles);
                continue;
            }
            if (!name.equals("\u4ed5\u5165") && !name.equals("\u4ed5\u5165\u91d1\u984d") && !name.equals("\u4ed5\u5165\u9ad8") && !accountTitleDisplayNames.contains("\u4ed5\u5165")) continue;
            this.purchaseAccountTitles.addAll(accountTitles);
        }
    }

    public Node<Map.Entry<List<AccountTitle>, Amount>> getNode(String name) {
        List<Node<Map.Entry<List<AccountTitle>, Amount>>> list = this.flatten(this.getRoot());
        for (Node<Map.Entry<List<AccountTitle>, Amount>> node : list) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    public List<AccountTitle> getAccountTitlesByNode(Node<Map.Entry<List<AccountTitle>, Amount>> node) {
        List<Node<Map.Entry<List<AccountTitle>, Amount>>> list = this.flatten(this.getRoot());
        for (Node<Map.Entry<List<AccountTitle>, Amount>> n : list) {
            if (!node.equals(n)) continue;
            return List.copyOf((Collection)n.getValue().getKey());
        }
        return null;
    }

    private List<Node<Map.Entry<List<AccountTitle>, Amount>>> flatten(Node<Map.Entry<List<AccountTitle>, Amount>> node) {
        ArrayList<Node<Map.Entry<List<AccountTitle>, Amount>>> list = new ArrayList<Node<Map.Entry<List<AccountTitle>, Amount>>>();
        list.add(node);
        for (Node<Map.Entry<List<AccountTitle>, Amount>> child : node.getChildren()) {
            list.addAll(this.flatten(child));
        }
        return list;
    }

    public boolean isSignReversed(String name) {
        return this.signReversedNames.contains(name);
    }

    public boolean isAlwaysShown(String name) {
        return this.alwaysShownNames.contains(name);
    }

    public boolean isAlwaysHidden(String name) {
        return this.alwaysHiddenNames.contains(name);
    }

    public boolean isHiddenIfZero(String name) {
        return this.hiddenNamesIfZero.contains(name);
    }

    public String getYaml() {
        return this.getYaml(null);
    }

    public String getYaml(Set<AccountTitle> filter) {
        StringBuilder out = new StringBuilder();
        this.retrieve(out, this.getRoot(), filter);
        out.append("\r\n");
        out.append("\"\u640d\u76ca\u8a08\u7b97\u66f8\u306e\u8868\u793a\u5236\u5fa1\" :\r\n");
        out.append("  \"\u7b26\u53f7\u3092\u53cd\u8ee2\u3057\u3066\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\" : [");
        Iterator<String> it1 = this.getSignReversedNames().iterator();
        while (it1.hasNext()) {
            out.append("\"");
            out.append(YamlBeansUtil.escape(it1.next()));
            out.append("\"");
            if (!it1.hasNext()) continue;
            out.append(", ");
        }
        out.append("]\r\n");
        out.append("  \"\u5e38\u306b\u8868\u793a\u3059\u308b\u898b\u51fa\u3057\" : [");
        Iterator<String> it2 = this.getAlwaysShownNames().iterator();
        while (it2.hasNext()) {
            out.append("\"");
            out.append(YamlBeansUtil.escape(it2.next()));
            out.append("\"");
            if (!it2.hasNext()) continue;
            out.append(", ");
        }
        out.append("]\r\n");
        out.append("  \"\u5e38\u306b\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057\" : [");
        Iterator<String> it3 = this.getAlwaysHiddenNames().iterator();
        while (it3.hasNext()) {
            out.append("\"");
            out.append(YamlBeansUtil.escape(it3.next()));
            out.append("\"");
            if (!it3.hasNext()) continue;
            out.append(", ");
        }
        out.append("]\r\n");
        out.append("  \"\u30bc\u30ed\u306a\u3089\u8868\u793a\u3057\u306a\u3044\u898b\u51fa\u3057\" : [");
        Iterator<String> it4 = this.getHiddenNamesIfZero().iterator();
        while (it4.hasNext()) {
            out.append("\"");
            out.append(YamlBeansUtil.escape(it4.next()));
            out.append("\"");
            if (!it4.hasNext()) continue;
            out.append(", ");
        }
        out.append("]\r\n");
        out.append("\r\n\r\n");
        return out.toString();
    }

    private void retrieve(StringBuilder out, Node<Map.Entry<List<AccountTitle>, Amount>> node, Set<AccountTitle> filter) {
        List<AccountTitle> accountTitles = node.getValue().getKey();
        if (filter != null) {
            ArrayList<AccountTitle> tmp = new ArrayList<AccountTitle>();
            for (AccountTitle accountTitle : accountTitles) {
                if (!filter.contains(accountTitle)) continue;
                tmp.add(accountTitle);
            }
            accountTitles = tmp;
        }
        String indent = "  ".repeat(node.getLevel() + 1);
        out.append(indent);
        out.append("\"");
        out.append(YamlBeansUtil.escape(node.getName()));
        out.append("\" :");
        if (accountTitles.size() > 0) {
            out.append(" [ ");
            for (int i = 0; i < accountTitles.size(); ++i) {
                out.append("\"");
                out.append(accountTitles.get(i).getDisplayName());
                out.append("\"");
                if (i + 1 >= accountTitles.size()) continue;
                out.append(", ");
            }
            out.append(" ]");
        }
        out.append("\r\n");
        if (accountTitles.size() == 0) {
            for (Node node2 : node.getChildren()) {
                this.retrieve(out, node2, filter);
            }
        }
    }
}

