# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

import gtk
import pygtk
import gobject

from aoiso.common.node import AoisoNode
from aoiso.gtk.aoisoGtkTreeStore import AoisoGtkTreeStore
from aoiso.common.aoisoConsts import AoisoConsts as c

drop_yes = ("drop_yes", gtk.TARGET_SAME_WIDGET, 0)
drop_no = ("drop_no", gtk.TARGET_SAME_WIDGET, 0)


class AoisoGtkTreeView(gtk.TreeView):

    def __init__(self):
        print "teeview_init"
        print c.COL_ICON
        print c.COL_TEXT
        print c.COL_OBJECT

        gtk.TreeView.__init__(self)
        #store = AoisoGtkTreeStore(self,gtk.gdk.Pixbuf,gobject.TYPE_STRING,gobject.TYPE_PYOBJECT)
        #self.set_model(store)

        #Column Settings
        column = gtk.TreeViewColumn()
        column.set_title('item')
        render_pixbuf = gtk.CellRendererPixbuf()
        column.pack_start(render_pixbuf,expand=False)
        column.add_attribute(render_pixbuf,'pixbuf',c.COL_ICON)
        render_text = gtk.CellRendererText()
        column.pack_start(render_text,expand=True)
        column.add_attribute(render_text,'text',c.COL_TEXT)
        self.append_column(column)

        self.connect('cursor_changed',self.on_cursor_changed)

        #self.current_iter = None 

        #DnD
        self.enable_model_drag_source( gtk.gdk.BUTTON1_MASK, [drop_yes], gtk.gdk.ACTION_MOVE)
        self.enable_model_drag_dest( [drop_yes], gtk.gdk.ACTION_MOVE)
        self.connect("drag_data_received", self.__on_drag_data_received)
        self.connect("drag_motion", self.__on_drag_motion)

    #def set_init_props(self,editor,title_entry):
    #    self.editor = editor
    #    self.title_entry = title_entry

    def on_cursor_changed(self,widget):
        print "selected!"
        self.get_model().showCurrentIter()
        """model,iter = self.get_selection().get_selected()
        self.current_iter = iter
        if iter!=None:
            node = model.get_value(iter,c.COL_OBJECT)
            self.editor.get_buffer().set_text(node.text)
            self.title_entry.set_text(node.title)       
        """
    #使ってない？
    #def __on_drag_data_get(self, treeView, context, selection, target_id, etime):
    #    print "aaa"
    #    treeselection = self.get_selection()
    #    model, iter = treeselection.get_selected()
    #    data = model.get_value(iter, 0)
    #    selection.set(selection.target, 8, data)

    def __on_drag_data_received(self, treeView, context, x, y, selection, info, etime):
        print "bbb"
        model,src_iter = self.get_selection().get_selected()
        node = model.get_value(src_iter,c.COL_OBJECT)
        drop_info = self.get_dest_row_at_pos(x, y)
        if drop_info:
            print "drop_info"
            dest_path,dest_position = drop_info
            print dest_position
            dest_iter = model.get_iter(dest_path)
            #self.current_iter = src_iter
            if (dest_position == gtk.TREE_VIEW_DROP_BEFORE):
                self.get_model().moveNodeBefore(src_iter,dest_iter)
            elif (dest_position == gtk.TREE_VIEW_DROP_INTO_OR_BEFORE) or (dest_position == gtk.TREE_VIEW_DROP_INTO_OR_AFTER):
                self.get_model().moveNodeToChild(src_iter,dest_iter)
            elif (dest_position == gtk.TREE_VIEW_DROP_AFTER):
                self.get_model().moveNodeAfter(src_iter,dest_iter)
        else:
            print "else"
            self.get_model().moveNodeToChild(src_iter,dest_iter)
        
        if context.action == gtk.gdk.ACTION_MOVE:
            context.finish(True, True, etime)
        return

    def moveNodeLeft(self,widget):
        print "moveNodeLeft"

    def moveNodeRight(self,widget):
        print "moveNodeRight"

    def moveNodeUp(self,widget):
        print "moveNodeUp"

    def moveNodeDown(self,widget):
        print "moveNodeDown"

    def moveNodeTrash(self,widget):
        print "moveNodeTrash"

    def checkSanity(self, model, source, target):
        source_path = model.get_path(source)
        target_path = model.get_path(target)
        if target_path[0:len(source_path)] == source_path:
            print "Sanity_False"
            return False
        else:
            print "Sanity_True"
            return True

    #使ってない?
    #def checkParentability(self, model, target, drop_position):
    #    if (drop_position == gtk.TREE_VIEW_DROP_INTO_OR_BEFORE
    #        or drop_position == gtk.TREE_VIEW_DROP_INTO_OR_AFTER):
    #        print "Parentability_False"
    #        return False
    #    else:
    #        return True                                                                       

    def __on_drag_motion(self, treeview, drag_context, x, y, eventtime):
        try:
            target_path, drop_position = treeview.get_dest_row_at_pos(x, y)
            model, source = treeview.get_selection().get_selected()
            target = model.get_iter(target_path)
        except:
            return
        is_sane = self.checkSanity(model, source, target)
        is_parentable =  True #self.checkParentability(model, target, drop_position)
        if is_sane and is_parentable:
            treeview.enable_model_drag_dest([drop_yes], gtk.gdk.ACTION_MOVE)
        else:
            treeview.enable_model_drag_dest([drop_no], gtk.gdk.ACTION_MOVE)
