# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

import wx

class AoisoWxTreeCtrl(wx.TreeCtrl):

    def __init__(self, parent):
        style = wx.TR_HIDE_ROOT + wx.TR_TWIST_BUTTONS + wx.TR_NO_LINES + wx.TR_FULL_ROW_HIGHLIGHT + wx.TR_DEFAULT_STYLE
        wx.TreeCtrl.__init__(self, parent, -1, wx.DefaultPosition, wx.DefaultSize, style, wx.DefaultValidator, wx.ControlNameStr)
        imageList = wx.ImageList(16,16)
        self.root_image_idx = imageList.Add(wx.ArtProvider.GetBitmap(wx.ART_FOLDER,wx.ART_OTHER,(16,16)))
        self.normal_image_idx = imageList.Add(wx.ArtProvider.GetBitmap(wx.ART_NEW,wx.ART_OTHER,(16,16)))
        self.AssignImageList(imageList)
        self.addDummyData()
        self.__setEventHandler()
        return

    def addDummyData(self):
        root  = self.AddRoot("root", -1, -1, None)
        #item1 = self.AppendItem(root,  "item1", self.root_image_idx, -1, None)
        #item2 = self.AppendItem(item1, "item2", self.normal_image_idx, -1, None)
        #item3 = self.AppendItem(root,  "item3", self.root_image_idx, -1, None)
        #item4 = self.AppendItem(item3, "item4", self.normal_image_idx, -1, None)
        #self.Expand(root)

    def set_model(self, model):
        self.model = model

    def get_model(self):
        return self.model

    def __setEventHandler(self):
        self.Bind(wx.EVT_TREE_SEL_CHANGED, self.onTreeSelChanged)
        self.Bind(wx.EVT_TREE_BEGIN_DRAG, self.onTreeBeginDrag)
        self.Bind(wx.EVT_TREE_END_DRAG, self.onTreeEndDrag)
 
    def onTreeSelChanged(self, event):
        print "treeSelChanged"
        self.get_model().showCurrentIter()

    def onTreeBeginDrag(self, event):
        print "treeBeginDrag"
        event.Allow()
        self.dragItem = event.GetItem()

    def onTreeEndDrag(self, event):
        print "treeEndDrag"
        src_item = self.dragItem
        target_item = event.GetItem()
        if target_item != None:
            item, flag = self.HitTest(event.GetPoint())
            print "flag == %s" % flag
            status = self.__dropPointStatus(flag)
            if status==0: 
                self.get_model().moveNodeBefore(src_item, target_item)
            elif status==1: 
                self.get_model().moveNodeAfter(src_item, target_item)
            elif status==2: 
                self.get_model().moveNodeToChild(src_item, target_item)
            self.Expand(target_item)
   
    def __dropPointStatus(self, flag):
        if flag & wx.TREE_HITTEST_ONITEMBUTTON == wx.TREE_HITTEST_ONITEMBUTTON:
            return 0
        elif flag & wx.TREE_HITTEST_ONITEMICON == wx.TREE_HITTEST_ONITEMICON:
            return 2
        elif flag & wx.TREE_HITTEST_ONITEMINDENT == wx.TREE_HITTEST_ONITEMINDENT:
            return 0
        elif flag & wx.TREE_HITTEST_ONITEMLABEL == wx.TREE_HITTEST_ONITEMLABEL:
            return 2
        elif flag & wx.TREE_HITTEST_ONITEMRIGHT == wx.TREE_HITTEST_ONITEMRIGHT:
            return 1
        elif flag & wx.TREE_HITTEST_ONITEMSTATEICON == wx.TREE_HITTEST_ONITEMSTATEICON:
            return 1
        else:
            return 1


