# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

import gtk
import pygtk
import gobject

from aoiso.common.node import AoisoNode
from aoiso.common.aoisoConsts import AoisoConsts as c

class AoisoGtkTreeStore(gtk.TreeStore):

    def __init__(self, widget, *args):
        gtk.TreeStore.__init__(self, *args)
        self.treeView = widget

#------GtkTreeStore inherited--------------

    #override 一応作っておく
    def set_value(self, iter, column, value):
        gtk.TreeStore.set_value(self, iter, column, value)

    def __reset_icon(self, iter):
        self.set_value(iter, c.COL_ICON, self.__get_icon_pixbuf(iter))

    #override
    def insert(self, parent, position, row=None):
        iter = gtk.TreeStore.insert(parent, position, row)
        self.__reset_icon(iter)
        return iter
    
    #override
    def insert_before(self, parent, sibling, row=None):
        iter = gtk.TreeStore.insert_before(self, parent, sibling, row=None)
        self.__reset_icon(iter)
        return iter

    #override
    def insert_after(self, parent, sibling, row=None):
        iter = gtk.TreeStore.insert_after(self, parent, sibling, row=None)
        self.__reset_icon(iter)
        return iter

    #override
    def append(self, parent, row=None):
        print "store_append"
        iter = gtk.TreeStore.append(self, parent, row)
        self.__reset_icon(iter)
        return iter

    #override
    def move_after(self, iter, position):
        gtk.TreeStore.move_after(iter, position)
        self.__reset_icon(iter)

    #override
    def move_before(self, iter, position):
        gtk.TreeStore.move_before(iter, position)
        self.__reset_icon(iter)

#---------AoisoWx Compatible-------------
    
    def setNode(self, iter, node):
        self.set_value(iter, c.COL_ICON, self.__get_icon_pixbuf(iter))
        self.set_value(iter, c.COL_TEXT, node.title)
        self.set_value(iter, c.COL_OBJECT, node)

    #Same
    def resetNode(self, iter):
        node = AoisoNode("NonTitled","")
        self.setNode(iter, node)

    def getCurrentIter(self):
        model,iter = self.treeView.get_selection().get_selected()
        return iter

    def appendNewNode(self):
        print "appendNewNode"
        current_iter = self.getCurrentIter()
        if current_iter==None:
            iter = self.append(None)
        else:
            iter = self.insert_after(self.iter_parent(current_iter),current_iter)
        self.resetNode(iter)
        self.treeView.expand_to_path(self.get_path(iter))
        self.treeView.get_selection().select_iter(iter)
        self.treeView.on_cursor_changed(self)

    def appendNewChildNode(self):
        iter = self.append(self.getCurrentIter())
        self.resetNode(iter)
        self.treeView.expand_to_path(self.get_path(iter))
        self.treeView.get_selection().select_iter(iter)
        self.treeView.on_cursor_changed(self)

    #Same
    def connectTitleEntry(self, titleEntry):
        self.titleEntry = titleEntry
    #Same
    def connectEditor(self, editor):
        self.editor = editor

    def showCurrentIter(self):
        print "showCurrentIter"
        iter = self.getCurrentIter()
        if iter != None:
            node = self.get_value(iter, c.COL_OBJECT)
            self.editor.get_buffer().set_text(node.text)
            self.titleEntry.set_text(node.title)       
        
    #Same
    def storeNodeText(self,text):
        iter = self.getCurrentIter()
        if iter != None:
            node = self.get_value(iter,c.COL_OBJECT)
            if node == None:
                print "Node is None"
            else:
                node.text = text
    #Same
    def storeNodeTitle(self,title):
        iter = self.getCurrentIter()
        if iter != None:
            node = self.get_value(iter,c.COL_OBJECT)
            if node == None:
                print "Node is None"
            else:
                node.title = title
                self.set_value(iter,c.COL_TEXT,title)

    #Same
    def moveNodeBefore(self,src_iter,dest_iter):
        print "moveNodeBefore"
        node = self.get_value(src_iter,c.COL_OBJECT)
        new_iter = self.insert_before(self.iter_parent(dest_iter), dest_iter)
        self.set_value(new_iter,c.COL_TEXT,node.title)
        self.set_value(new_iter,c.COL_OBJECT,node)
        i = 0
        while i <= self.iter_n_children(src_iter) - 1:
            iter = self.iter_nth_child(src_iter,i)
            self.moveNodeToChild(iter,new_iter)
            i += 1
        #self.remove(src_iter)

    #Same
    def moveNodeAfter(self,src_iter,dest_iter):
        print "moveNodeAfter"
        node = self.get_value(src_iter,c.COL_OBJECT)
        new_iter = self.insert_after(self.iter_parent(dest_iter), dest_iter)
        self.set_value(new_iter,c.COL_TEXT,node.title)
        self.set_value(new_iter,c.COL_OBJECT,node)
        i = 0
        while i <= self.iter_n_children(src_iter) - 1:
            iter = self.iter_nth_child(src_iter,i)
            self.moveNodeToChild(iter,new_iter)
            i += 1
        #self.remove(src_iter)

    #Same
    def moveNodeToChild(self,src_iter,dest_iter):
        print "moveNodeChild"
        node = self.get_value(src_iter,c.COL_OBJECT)
        new_iter = self.append(dest_iter)
        self.set_value(new_iter,c.COL_TEXT,node.title)
        self.set_value(new_iter,c.COL_OBJECT,node)
        i = 0
        while i <= self.iter_n_children(src_iter) - 1:
            iter = self.iter_nth_child(src_iter,i)
            self.moveNodeToChild(iter,new_iter)
            i += 1
        #self.remove(src_iter)

#---------Original---------------------

    def __get_icon_pixbuf(self, iter):
        if self.iter_parent(iter)==None:
            stock_icon = gtk.STOCK_DIRECTORY
        else:
            stock_icon = gtk.STOCK_DND
        return self.treeView.render_icon(stock_icon,size=gtk.ICON_SIZE_MENU,detail=None)
