# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA


import wx
import wx.xrc as xrc
from aoiso.wx.aoisoWxTreeStore import AoisoWxTreeStore
from aoiso.common.logic import AoisoLogic
from aoiso.wx.aoisoWxMainFrame import AoisoWxMainFrame

class AoisoWxApp(wx.App):

    def OnInit(self):
        self.res = xrc.XmlResource("aoiso.xrc")
        self.window = AoisoWxMainFrame(self)
        self.model = AoisoWxTreeStore(self.window.treeView)
        self.model.connectTitleEntry(self.window.titleEntry)
        self.model.connectEditor(self.window.editor)
        self.window.treeView.set_model(self.model)
        self.logic = AoisoLogic(self.model)
        self.window.Show()
        return True
