# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

import wx
import wx.xrc as xrc

from aoiso.wx.aoisoWxTreeCtrl import AoisoWxTreeCtrl
from aoiso.common.aoisoConsts import AoisoConsts as c

class AoisoWxMainFrame(wx.Frame):

    def __init__(self, app, parent=None):
        self.app = app
        pre = wx.PreFrame()
        app.res.LoadOnFrame(pre, parent, "ID_MAIN_FRAME")
        self.PostCreate(pre)
        self.__setEventHandler()
        self.SetSize((700,500))
        self.SetPosition((200,200))
        
        panel = xrc.XRCCTRL(self, "ID_TREE_PANEL")
        self.treeCtrl = AoisoWxTreeCtrl(panel)
        self.treeView = self.treeCtrl # for Gtk Compatiblity
        app.res.AttachUnknownControl("ID_TREE_CTRL", self.treeCtrl, panel)
        panel.Fit()

        self.titleEntry = xrc.XRCCTRL(self,"ID_TITLE_ENTRY")
        self.editor = xrc.XRCCTRL(self,"ID_EDITOR")
        self.lastDir = ""
        self.lastFilename = ""
        self.lastPath = ""

    def __setEventHandler(self):
        #Menu
        self.Bind(wx.EVT_MENU, self.onFileNewClick,     id=xrc.XRCID("ID_FILE_NEW"))
        self.Bind(wx.EVT_MENU, self.onFileOpenClick,    id=xrc.XRCID("ID_FILE_OPEN"))
        self.Bind(wx.EVT_MENU, self.onFileSaveOverClick,    id=xrc.XRCID("ID_FILE_SAVE_OVER"))
        self.Bind(wx.EVT_MENU, self.onFileSaveAsClick,  id=xrc.XRCID("ID_FILE_SAVE_AS"))
        self.Bind(wx.EVT_MENU, self.onNodeLeftClick,    id=xrc.XRCID("ID_NODE_LEFT"))
        self.Bind(wx.EVT_MENU, self.onNodeRightClick,   id=xrc.XRCID("ID_NODE_RIGHT"))
        self.Bind(wx.EVT_MENU, self.onNodeUpClick,      id=xrc.XRCID("ID_NODE_UP"))
        self.Bind(wx.EVT_MENU, self.onNodeDownClick,    id=xrc.XRCID("ID_NODE_DOWN"))
        self.Bind(wx.EVT_MENU, self.onNodeAddClick,     id=xrc.XRCID("ID_NODE_ADD"))
        self.Bind(wx.EVT_MENU, self.onNodeAddChildClick,  id=xrc.XRCID("ID_NODE_ADD_CHILD"))
        self.Bind(wx.EVT_MENU, self.onNodeTrashClick,  id=xrc.XRCID("ID_NODE_TRASH"))
        #Editor
        self.Bind(wx.EVT_TEXT, self.onTitleEntryChanged, id=xrc.XRCID("ID_TITLE_ENTRY"))
        self.Bind(wx.EVT_TEXT, self.onEditorChanged, id=xrc.XRCID("ID_EDITOR"))
        
    def onFileNewClick(self, event):
        print "file_new"
        self.app.logic.clearDocument()
        self.lastDir = ""
        self.lastFilename = ""
        self.lastPath = ""
        self.__refreshFormStatus()

    def onFileOpenClick(self, event):
        print "file_open"
        dialog = wx.FileDialog(self, "Open Document File",self.lastDir,self.lastFilename,
                "AOISO XML files (*.xml)|*.xml|Dot indented Text File *.txt|*.txt", 
                wx.FD_OPEN + wx.FD_FILE_MUST_EXIST)
        ret = dialog.ShowModal()
        print ret
        if ret==5100:
            print "path:"+dialog.GetPath()
            self.app.logic.openDocument(dialog.GetPath())
            self.lastPath = dialog.GetPath()
            self.lastDir = dialog.GetDirectory()
            self.lastFilename = dialog.GetFilename()
            self.__refreshFormStatus()

    def onFileSaveOverClick(self, event):
        print "file_save_over"
        if self.lastPath=="":
            self.onFileSaveAsClick(event)
        else:
            self.app.logic.saveDocument(self.lastPath, c.FILE_TYPE_AOISO)
            self.__refreshFormStatus()

    def onFileSaveAsClick(self, event):
        print "file_save_as"
        dialog = wx.FileDialog(self, "Save Document File",self.lastDir,self.lastFilename,
                "AOISO XML files (*.xml)|*.xml|Dot indented Text File *.txt|*.txt", 
                wx.FD_SAVE)
        ret = dialog.ShowModal()
        print ret
        if ret==5100:
            print "path:"+dialog.GetPath()
            self.lastPath, self.lastDir, self.lastFilename  = self.app.logic.saveDocument(
                                                    dialog.GetPath(),dialog.GetFilterIndex())
            self.__refreshFormStatus()

    def __refreshFormStatus(self):
        if self.lastFilename == "":
            self.SetTitle("AOISO")
        else:
            self.SetTitle("AOISO - "+self.lastFilename)

    def onNodeLeftClick(self, event):
        print "node_left"

    def onNodeRightClick(self, event):
        print "node_right"

    def onNodeUpClick(self, event):
        print "node_up"

    def onNodeDownClick(self, event):
        print "node_down"
        
    def onNodeAddClick(self, event):
        print "node_add"
        self.app.logic.appendNode(self)

    def onNodeAddChildClick(self, event):
        print "node_add_child"
        self.app.logic.appendChildNode(self)
    def onNodeTrashClick(self, event):
        print "node_trash"
        self.app.logic.deleteNode()

    def onTitleEntryChanged(self, event):
        self.app.model.storeNodeTitle(self.titleEntry.GetValue())
    
    def onEditorChanged(self, event):
        self.app.model.storeNodeText(self.editor.GetValue())

