# coding: UTF-8

# AOISO Outline Processor
# Copyright (C) 2007 H.WAKIMOTO
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

import wx
from aoiso.common.aoisoConsts import AoisoConsts as c
from aoiso.common.node import AoisoNode

class AoisoWxTreeStore():

    def __init__(self, treeCtrl):
        self.treeCtrl = treeCtrl
        self.treeView = treeCtrl # for Gtk Emulate

#---------GTK Compatible--------------------
    """
    Not Implemented mothods
    - set
    - remove
    - prepend
    - is_ancestor
    - iter_depth
    - iter_is_valid
    - reoder
    - swap
    and some GtkTreeModel methods
    """

    #Gtk TreeStore Compatible
    def set_value(self, item, column, value):
        #print "set_value"
        if column==c.COL_TEXT:
            self.treeCtrl.SetItemText(item, value)
            #print value
        elif column==c.COL_OBJECT:
            self.treeCtrl.SetItemPyData(item, value)
            #print value
        elif column==c.COL_ICON:
            print "column==icon not implemented !"

    #Gtk TreeStore Compatible
    def get_value(self, item, column):
        #print "get_value"
        if column==c.COL_TEXT:
            return self.treeCtrl.GetItemText(item)
        elif column==c.COL_OBJECT:
            return self.treeCtrl.GetItemPyData(item)
        elif column==c.COL_ICON:
            print "column=icon not implemented !"
            return None

    #Gtk TreeStore Compatible
    def clear(self):
        print "clear"
        self.treeCtrl.DeleteAllItems()
        item = self.treeCtrl.AddRoot("root", -1, -1, None)
        self.resetNode(item)
    
    #Gtk TreeStore Compatible
    def append(self, parent):
        print "append"
        return self.__append_item(parent, "", self.__get_image_idx(parent), -1, None)

    #Gtk TreeStore Compatible
    #//!! position ??
    def insert(self, item, position, row=None):
        print "insert - warning - this method is under constructions !"
        return self.__insert_item_after(parent, position, "", self.__get_image_idx(parent),  -1, None)

    #Gtk TreeStore Compatible
    def insert_before(self, parent, sibling, row=None):
        print "insert_before"
        return self.__insert_item_before(parent, sibling, "", self.__get_image_idx(parent), -1, None)

    #Gtk TreeStore Compatible
    def insert_after(self, parent, sibling, row=None):
        print "insert_after"
        return self.__insert_item_after(parent, sibling, "", self.__get_image_idx(parent), -1, None)
    #Gtk TreeStore Compatible
    def remove(self, item):
        print "remove"
        if item!=self.getHiddenRoot():
            self.treeCtrl.Delete(item)

    #Gtk TreeStore Compatible
    def move_after(self, item, position):
        print "move_after not implemented !"

    #Gtk TreeStore Compatible
    def move_before(self, item, position):
        print "move_before not implemented !"

    #Gtk TreeStore Compatible
    def iter_n_children(self, parent):
        print "iter_n_children : %d" % self.treeCtrl.GetChildrenCount(parent, False)
        return self.treeCtrl.GetChildrenCount(parent, False);

    #Gtk TreeStore Compatible
    def iter_nth_child(self, parent, number):
        item, cookie = self.treeCtrl.GetFirstChild(parent)
        for i in range(number - 1):
            item, cookie = self.treeCtrl.GetNextChild(parent, cookie)
        if item==None:
            print "iter_nth_child failed !"
        print "iter_nth_child : %d" % number + self.get_value(item,c.COL_TEXT)
        return item 

    #Gtk TreeStore Compatible
    def iter_parent(self, item):
        print "iter_parent"
        return self.treeCtrl.GetItemParent(item)

    #Gtk TreeStore Compatible
    def iter_next(self, item):
        print "iter_next"
        return self.treeCtrl.GetNextSibling(item)

    #Gtk TreeStore Compatible
    def get_iter_root(self):
        print "get_iter_root"
        root_item = self.getHiddenRoot()
        item, cookie = self.treeCtrl.GetFirstChild(root_item)
        return item 

#-------AoisoGtk Compatible-----------------

    def setNode(self, item, node):
        print "setNode"
        #self.set_value(item, c.COL_ICON, self.__get_icon_pixbuf(item))
        self.set_value(item, c.COL_TEXT, node.title)
        self.set_value(item, c.COL_OBJECT, node)

    #Same
    def resetNode(self, item):
        print "resetNode"
        node = AoisoNode("NonTitled","")
        self.setNode(item, node)

    def getCurrentIter(self):
    #    print "GetCurrentIter"
        return self.treeCtrl.GetSelection()

    def appendNewNode(self):
        print "appendNewNode"
        current_item = self.getCurrentIter()
        if current_item==self.treeCtrl.GetRootItem():
            item = self.append(current_item)
        else:
            item = self.insert_after(self.iter_parent(current_item),current_item)
        self.resetNode(item)
        self.treeCtrl.SelectItem(item)
        #self.treeView.on_cursor_changed(widget)

    def appendNewChildNode(self):
        item = self.append(self.getCurrentIter())
        self.resetNode(item)
        self.treeCtrl.SelectItem(item)
        #self.treeView.on_cursor_changed(widget)

    #Same
    def connectTitleEntry(self, titleEntry):
        self.titleEntry = titleEntry
    #Same
    def connectEditor(self, editor):
        self.editor = editor

    def showCurrentIter(self):
        print "showCurrentIter"
        item = self.getCurrentIter()
        if item != None:
            node = self.get_value(item, c.COL_OBJECT)
            self.editor.SetValue(node.text)
            self.titleEntry.SetValue(node.title)

    #Same
    def storeNodeText(self,text):
        item = self.getCurrentIter()
        if item != None:
            node = self.get_value(item,c.COL_OBJECT)
            if node == None:
                print "Node is None"
            else:
                node.text = text
    #Same
    def storeNodeTitle(self,title):
        item = self.getCurrentIter()
        if item != None:
            node = self.get_value(item,c.COL_OBJECT)
            if node == None:
                print "Node is None"
            else:
                node.title = title
            self.set_value(item,c.COL_TEXT,title)

    def moveNodeBefore(self, src_item, dest_item):
        print "moveNodeBefore"
        node = self.get_value(src_item,c.COL_OBJECT)
        new_item = self.insert_before(self.iter_parent(dest_item), dest_item)
        self.set_value(new_item,c.COL_TEXT,node.title)
        self.set_value(new_item,c.COL_OBJECT,node)
        i = 0
        while i <= self.iter_n_children(src_item) - 1:
            item = self.iter_nth_child(src_item,i)
            self.moveNodeToChild(item,new_item)
            i += 1
        self.remove(src_item)
        return new_item

    def moveNodeAfter(self, src_item, dest_item):
        print "moveNodeAfter"
        node = self.get_value(src_item,c.COL_OBJECT)
        new_item = self.insert_after(self.iter_parent(dest_item), dest_item)
        self.set_value(new_item,c.COL_TEXT,node.title)
        self.set_value(new_item,c.COL_OBJECT,node)
        i = 0
        while i <= self.iter_n_children(src_item) - 1:
            item = self.iter_nth_child(src_item,i)
            self.moveNodeToChild(iter,new_item)
            i += 1
        self.remove(src_item)
        return new_item

    def moveNodeToChild(self, src_item, dest_item):
        print "moveNodeToChild"
        node = self.get_value(src_item,c.COL_OBJECT)
        new_item = self.append(dest_item)
        self.set_value(new_item,c.COL_TEXT,node.title)
        self.set_value(new_item,c.COL_OBJECT,node)
        i = 0
        while i <= self.iter_n_children(src_item) - 1:
            iter = self.iter_nth_child(src_item,i)
            self.moveNodeToChild(iter,new_item)
            i += 1
        self.remove(src_item)
        return new_item

#-------Original----------------------------

    #Gtk TreeStore "get_root_iter" compatible
    def getHiddenRoot(self):
        print "get_hidden_root"
        return self.treeCtrl.GetRootItem()

    def isParentItem(self, parent, child):
        item = self.iter_parent(child)
        while item!=self.getHiddenRoot():
            if item == parent:
                return True
            else:
                item = self.iter_parent(item)
        return False 

    #original
    def __append_item(self, parent, text, image, selectedImage, data):
        if parent==None:
            print "__append_item -> root parent=None "+text
            return self.treeCtrl.AppendItem(self.treeCtrl.GetRootItem(), text, image, selectedImage, data)
        else:
            print "__append_item "+text
            return self.treeCtrl.AppendItem(parent, text, image, selectedImage, data)

    #original
    def __insert_item_before(self, parent, index, text, image, selectedImage, data):
        return self.treeCtrl.InsertItemBefore(parent, index, text, image, selectedImage, data)

    #original
    def __insert_item_after(self, parent, idPrevious, text, image, selectedImage, data):
        return self.treeCtrl.InsertItem(parent, idPrevious, text, image, selectedImage, data)

    #original
    def __get_image_idx(self, parent):
        if parent==None:
            return self.treeCtrl.root_image_idx
        elif parent==self.treeCtrl.GetRootItem():
            return self.treeCtrl.root_image_idx
        else:
            return self.treeCtrl.normal_image_idx
