<?php
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'aspect' . DIRECTORY_SEPARATOR . 'ConfigurationManager.class.php';
//ini_set("memory_limit", "64M");
ini_set("memory_limit", "516M");
AOWP_Logger::$LOGGING_FLAG = true;
AOWP_ConfigurationManager::$WEAVING_TIME_FLAG = true;
$_AOWP_CLASS_PATH = realpath(dirname(__FILE__) . "/../classes");
$commandOption = new AOWP_CommandOption($argv, $argc);
if ($commandOption->isDoSetupEnv()) {
	if (include $commandOption->getConfigFilePath()) {
		if (isset($AOWP_CONF_INCLUDE_FILE_PATTERN)) {
			$AOWP_CONF_INCLUDE_FILE_PATTERN = '/.php$/';
		}
		if (isset($AOWP_CONF_EXCLUDE_FILE_PATTERN)) {
			$AOWP_CONF_EXCLUDE_FILE_PATTERN = '/.bk$/';
		}
		if (isset($AOWP_CONF_AOWP_HOME) && isset($AOWP_CONF_PROJECT_PATH) &&
			isset($AOWP_CONF_ASPECT_PATH) & isset($AOWP_CONF_DATA_FOLDER_NAME)) {

			AOWP_ConfigurationManager::setupConfiguration(
				$AOWP_CONF_AOWP_HOME,
				$AOWP_CONF_PROJECT_PATH,
				$AOWP_CONF_ASPECT_PATH,
				$AOWP_CONF_DATA_FOLDER_NAME,
				$AOWP_CONF_INCLUDE_FILE_PATTERN,
				$AOWP_CONF_EXCLUDE_FILE_PATTERN);
			AOWP_ConfigurationManager::includeAOWPClasses();
			
			// Create data folder for weaving.
			if (!file_exists($AOWP_CONF_AOWP_HOME . DIRECTORY_SEPARATOR . $AOWP_CONF_DATA_FOLDER_NAME)) {
				AOWP_Logger::setStartTime();
				mkdir($AOWP_CONF_AOWP_HOME . DIRECTORY_SEPARATOR . $AOWP_CONF_DATA_FOLDER_NAME);
				AOWP_Logger::logging('[Mkdir] Make cache data folder <' . $AOWP_CONF_AOWP_HOME . DIRECTORY_SEPARATOR . $AOWP_CONF_DATA_FOLDER_NAME . '>');
			}
		}
		else {
			exit();
		}
	}
	else {
		exit();
	}
}
if ($commandOption->isDoParse()) {
	AOWP_ConfigurationManager::includeAOWPClasses();
	AOWP_Logger::logging('[AOWP compiler] Start parsing.');
	AOWP_Logger::setStartTime(1);
	$astManager = new AOWP_ASTManager();
	$astManager->createAllASTCache();
	AOWP_Logger::logging('[AOWP compiler] End parsing.', 1);
}
if ($commandOption->isDoWeaving()) {
	AOWP_ConfigurationManager::includeAOWPClasses();
	AOWP_Logger::logging('[AOWP compiler] Start weaving.');
	AOWP_Logger::setStartTime(3);
	$weaver = new AOWP_Weaver();
	$weaver->weaveAllAspect();
	AOWP_Logger::logging('[AOWP compiler] End weaving.', 3);
}
if ($commandOption->isDoGenerateWovenSource()) {
	AOWP_ConfigurationManager::includeAOWPClasses();
	AOWP_Logger::logging('[AOWP compiler] Start generating source.');
	AOWP_Logger::setStartTime(3);
	AOWP_ASTManager::generateWovenSource();
	AOWP_Logger::logging('[AOWP compiler] End generating source.', 3);
	AOWP_ConfigurationManager::setupRuntimeEnvironment();
	AOWP_Logger::logging('[AOWP compiler] Setup runtime environment.');
}
if ($commandOption->isDoUndo()) {
	AOWP_ConfigurationManager::includeAOWPClasses();
	AOWP_PHPFileManager::undoWeaving();
}

class AOWP_CommandOption {
	private $_configFilePath = null;
	private $_isDoSetupEnv = false;
	private $_isDoParse = false;
	private $_isDoWeaving = false;
	private $_isDoGenerateWovenSource = false;
	private $_isDoUndo = false;
	
	public function __construct($argv, $argc) {
		if (!isset($argv) || !isset($argc)) {
			echo "Bad arguments\n.";
			exit();
		}
		for ($i = 0; $i < $argc; $i++) {
			switch ($argv[$i]) {
				case 'config':
					if ($i + 1 <= $argc) {
						$i++;
						$this->_configFilePath = $argv[$i]; 
					}
					else {
						echo 'Need a path of a configuration file.';
						exit();
					}
					break;
				case 'env':
					$this->_isDoSetupEnv = true;
					break;
				case 'parse':
					$this->_isDoParse = true;
					break;
				case 'weaving':
					$this->_isDoWeaving = true;
					break;
				case 'source':
					$this->_isDoGenerateWovenSource = true;
					break;
				case 'undo':
					$this->_isDoUndo = true;
					break;
				case 'all':
					$this->_isDoSetupEnv = true;
					$this->_isDoParse = true;
					$this->_isDoWeaving = true;
					$this->_isDoGenerateWovenSource = true;
					break;
			}
			$this->_configFilePath = $this->_configFilePath !== null ? $this->_configFilePath : 'aowp_conf.php';
		}
	}
	
	public function getConfigFilePath() {
		return $this->_configFilePath;
	}
	public function isDoSetupEnv() {
		return $this->_isDoSetupEnv;
	}
	public function isDoParse() {
		return $this->_isDoParse;
	}
	public function isDoWeaving() {
		return $this->_isDoWeaving;
	}
	public function isDoGenerateWovenSource() {
		return $this->_isDoGenerateWovenSource;
	}
	public function isDoUndo() {
		return $this->_isDoUndo;
	}
}
?>