<?php
/**
 * Aspect.class
 * 
 * @package aowp.aspect
 */
abstract class AOWP_Aspect {
	
	private static $_instance = null;
	
	/**
	 * Precedence. 
	 */
	private $_precedence = 0;
	
	/**
	 * Advice.
	 */
	private $_adviceArray = array();

	public function getNumOfAdvice() {
		return count($this->_adviceArray);
	}
	
	public function getAdviceAt($idx) {
		return $this->_adviceArray[$idx];
	}
	
	/**
	 * Add Advice to $_adviceArray
	 * @param AOWP_Advice $advice
	 */
	public function addAdvice(AOWP_Advice $advice) 
	{
		$adviceNextIndex = count($this->_adviceArray);
		$advice->setClassNameOfAspect(get_class($this));
		$advice->setIndex($adviceNextIndex);
		$this->_adviceArray[$adviceNextIndex] = $advice;
	}
	
	/**
	 * 一つのジョインポイントに対してポイントカットを評価し、織り込みを行います。
	 *
	 * @param AOWP_JoinPoint $joinPoint 評価対象のジョインポイント
	 */
	public function weave(AOWP_JoinPoint $joinPoint) 
	{
		for ($i = 0; $i < count($this->_adviceArray); $i++) {
			if ($this->_adviceArray[$i]->match($joinPoint)) {
//				AOWP_Logger::logging('[Weave] Pointcut match: ' . get_class($joinPoint));
				$this->_adviceArray[$i]->weave($joinPoint);
			}
		}
	}
	
	public function runtimeMatch($index, AOWP_Context $context){
		return $this->_adviceArray[$index]->runtimeMatch($context);
	}
	
	/**
	 * Execute Advice body.
	 */
	public function executeAdvice($index, AOWP_Context $context)
	{
		$adviceBodyName = $this->_adviceArray[$index]->getAdviceBodyFunctionName();
		return $this->$adviceBodyName($context);
	}
	
	public function setPrecedence($precedence) {
		$this->_precedence = $precedence;
	}
	
	public function getPrecedence() {
		return $this->_precedence;
	}
	
	public function generateAspect() {
		foreach ($this->_adviceArray as $advice) {
			AOWP_Aspect::_callGenerateAspect($advice->getPointcut());
		}
	}
	private static function _callGenerateAspect($pointcut) {
		if (is_subclass_of($pointcut, 'AOWP_Pointcut')) {
			foreach ($pointcut->getAndPointcutArray() as $andPointcut) {
				AOWP_Aspect::_callGenerateAspect($andPointcut);
			}
			foreach ($pointcut->getOrPointcutArray() as $orPointcut) {
				AOWP_Aspect::_callGenerateAspect($orPointcut);
			}
		}
		if (in_array('AOWP_RichPointcut', class_implements($pointcut))) {
			$pointcut->generateAspect();
		}
	}
}
?>
