<?php
/**
 * Enter description here...
 *
 * @package aowp.aspect
 */
require_once 'include.php';

/**
 * Enter description here...
 *
 * @package aowp.aspect
 * @uses AOWP_AspectManager
 */
class AOWP_AspectInstanceManager {
	
	const DATA_FOLDER_NAME = 'AOWP_AspectInstanceManager';
	const APPLICATION_SCOPE_INSTANCE_SERIALIZATION_FOLDER = 'application';
	const LOCK_FILE_CHECK_INTERVAL = 100000;
	const SESSION_SCOPE_INSTANCE_SAVE_FOLDER = 'session';
	
	private static $_REQUEST_SCOPE_INSTANCE_ARRAY = array();
	
	private static function getDataFolderPath() {
		return AOWP_Configuration::RUNTIME_DATA_FOLDER . DIRECTORY_SEPARATOR . AOWP_Configuration::WAVING_DATA_DIR_NAME . DIRECTORY_SEPARATOR . AOWP_AspectInstanceManager::DATA_FOLDER_NAME . DIRECTORY_SEPARATOR;
	}
	
	public static function getInstance($aspectClassName) {
		if (AOWP_AspectManager::includeOnceAspect($aspectClassName)) {
			if (new $aspectClassName instanceof AOWP_IPerApplicationAspect) {
				return AOWP_AspectInstanceManager::_getApplicationScopeInstance($aspectClassName);
			}
			else if (new $aspectClassName instanceof AOWP_IPerSessionAspect) {
				return AOWP_AspectInstanceManager::_getSessionScopeInstance($aspectClassName);
			}
			else if (new $aspectClassName instanceof AOWP_IPerRequestAspect) {
				return AOWP_AspectInstanceManager::_getRequestScopeInstance($aspectClassName);
			}
			else {
				return new $aspectClassName;
			}
		}
		else {
			return null;
		}
	}
	public static function releaseInstance(AOWP_Aspect $aspectInstance) {
		if ($aspectInstance instanceof AOWP_IPerApplicationAspect) {
			AOWP_AspectInstanceManager::_releaseApplicationScopeInstance($aspectInstance);
		}
		else if ($aspectInstance instanceof AOWP_IPerSessionAspect) {
			AOWP_AspectInstanceManager::_releaseSessionScopeInstance($aspectInstance);
		}
		else if ($aspectInstance instanceof AOWP_IPerRequestAspect) {
			
		}
		else {
			
		}
	}
	
	private static function _getSerializedApplicationScopeInstancePath($aspectClassName) {
		return  AOWP_AspectInstanceManager::getDataFolderPath() .
			AOWP_AspectInstanceManager::APPLICATION_SCOPE_INSTANCE_SERIALIZATION_FOLDER . '/' . $aspectClassName;
	}
	private static function _getApplicationScopeInstanceLockPath($aspectClassName) {
		return AOWP_AspectInstanceManager::_getSerializedApplicationScopeInstancePath($aspectClassName) . '.lock';
	}
	private static function _lockApplicationScopeInstance($aspectClassName) {
		$lockFilePath = AOWP_AspectInstanceManager::_getApplicationScopeInstanceLockPath($aspectClassName);
		while (file_exists($lockFilePath)) {
			usleep(AOWP_AspectInstanceManager::LOCK_FILE_CHECK_INTERVAL);
		}
		file_put_contents($lockFilePath, '');
	}
	private static function _unlockApplicationScopeInstance($aspectClassName) {
		unlink(AOWP_AspectInstanceManager::_getApplicationScopeInstanceLockPath($aspectClassName));
	}
	private static function _getApplicationScopeInstance($aspectClassName) {
		$serializedInstancePath = AOWP_AspectInstanceManager::_getSerializedApplicationScopeInstancePath($aspectClassName);
		AOWP_AspectInstanceManager::_lockApplicationScopeInstance($aspectClassName);
		if (file_exists($serializedInstancePath)) {
			$serializedInstanceData = file_get_contents($serializedInstancePath);
			return unserialize($serializedInstanceData);
		}
		else {
			return new $aspectClassName;
		}
	}
	private static function _releaseApplicationScopeInstance(AOWP_IPerApplicationAspect $aspectInstance) {
		$aspectClassName = get_class($aspectInstance);
		$serializedInstanceData = serialize($aspectInstance);
		file_put_contents(AOWP_AspectInstanceManager::_getSerializedApplicationScopeInstancePath($aspectClassName), $serializedInstanceData);
		AOWP_AspectInstanceManager::_unlockApplicationScopeInstance($aspectClassName);
	}
	
	private static function _getSessionScopeInstanceSaveFolder() {
		$sessionID = session_id();
		if ($sessionID == null) {
			session_start();
			$sessionID = session_id();
		}
		$sessionScopeInstanceFolder = AOWP_AspectInstanceManager::getDataFolderPath() .
			AOWP_AspectInstanceManager::SESSION_SCOPE_INSTANCE_SAVE_FOLDER . DIRECTORY_SEPARATOR .
			$sessionID . DIRECTORY_SEPARATOR;
		if (!file_exists($sessionScopeInstanceFolder)) {
			AOWP_PHPFileManager::mkdir($sessionScopeInstanceFolder);
		}
		return $sessionScopeInstanceFolder;
	}
	private static function _releaseSessionScopeInstance(AOWP_IPerSessionAspect  $aspectInstance) {
		$serializationInstancePath = AOWP_AspectInstanceManager::_getSessionScopeInstanceSaveFolder() . get_class($aspectInstance);
		file_put_contents($serializationInstancePath, serialize($aspectInstance));
	}
	private static function _getSessionScopeInstance($aspectClassName) {
		$sessionScopeInstanceSaveFolder = AOWP_AspectInstanceManager::_getSessionScopeInstanceSaveFolder();
		$instanceSerializationFile = $sessionScopeInstanceSaveFolder . $aspectClassName;
		if (!file_exists($instanceSerializationFile)) {
			return new $aspectClassName;
		}
		else {
			return unserialize(file_get_contents($instanceSerializationFile));
		}
	}
	
	private static function _getRequestScopeInstance($aspectClassName) {
		if (array_key_exists($aspectClassName, AOWP_AspectInstanceManager::$_REQUEST_SCOPE_INSTANCE_ARRAY)) {
			return AOWP_AspectInstanceManager::$_REQUEST_SCOPE_INSTANCE_ARRAY[$aspectClassName];
		}
		else {
			$instance = new $aspectClassName;
			AOWP_AspectInstanceManager::$_REQUEST_SCOPE_INSTANCE_ARRAY[$aspectClassName] = $instance;
			return $instance;
		}
	}
	
	
}
?>