<?php
/**
 * @package aowp.aspect
 * 
 */

/**
 * ユーザが定義したアスペクトのパス情報を管理し、指定した名前のアスペクトの定義ファイルのinclude処理を行います。
 * アスペクトのパス情報は、織り込み時に設定され、serialize関数を用いて保存されます。
 * 実行時には、unserialize関数を用いて、織り込み時に作成したインスタンスを利用します。
 *
 * @package aowp.aspect
 */
class AOWP_AspectManager {
	
	const SERIALIZATION_FILE_NAME = 'AOWP_AspectManager';
	const ASPECT_DEFINITION_FILE_PATERN = '/\.aspect\.php$/';
	const WEAVER_GENERATE_ASPECT_FOLDER = 'aspects';
	private $_aspectFileMap = array();
	private $_weaverGenerateAspectFileMap = array();
	
	private static function _getSerializationLocation() {
		return AOWP_ConfigurationManager::getCacheFolder() . DIRECTORY_SEPARATOR . AOWP_AspectManager::SERIALIZATION_FILE_NAME;
	}
	
	private static function _getWeaverGenerateAspectFolderPath() {
		return AOWP_ConfigurationManager::getCacheFolder() . DIRECTORY_SEPARATOR . AOWP_AspectManager::WEAVER_GENERATE_ASPECT_FOLDER . DIRECTORY_SEPARATOR;
	}
	
	public static function clearCache() {
		AOWP_AspectManager::_serialize(new AOWP_AspectManager());
	}

	public static function loadUserDefineAspect() {
		$aspectManager = new AOWP_AspectManager();
		$phpScriptFilePathArray = AOWP_PHPFileManager::getAllAspectPHPFile();
		foreach ($phpScriptFilePathArray as $phpScriptFilePath) {
			$aspectManager->addAspectFilePath(AOWP_AspectManager::_getAspectName($phpScriptFilePath), $phpScriptFilePath);
		}
		AOWP_AspectManager::_serialize($aspectManager);
	}
	private static function _serialize($aspectManager) {
//		echo AOWP_AspectManager::_getSerializationLocation();
		file_put_contents(AOWP_AspectManager::_getSerializationLocation(), serialize($aspectManager));
		chmod(AOWP_AspectManager::_getSerializationLocation(), 0777);
	}
	private static function _getAspectName($filePath) {
		$pathInfomation = pathinfo($filePath);
		$fileName = $pathInfomation['basename'];
		$fileNameArray = explode('.', $fileName);
		return $fileNameArray[0];
	}
	
	public function addAspectFilePath($aspectName, $aspectFilePath) {
		$this->_aspectFileMap[$aspectName] = $aspectFilePath;
	}
	
	public function addWeaverGenerateAspectFilePath($aspectName, $aspectFilePath) {
		$this->_weaverGenerateAspectFileMap[$aspectName] = $aspectFilePath;
	}
	
	public function getAspectFilePath($aspectName) {
		if (array_key_exists($aspectName, $this->_aspectFileMap)) {
			return $this->_aspectFileMap[$aspectName];
		}
		else if (array_key_exists($aspectName, $this->_weaverGenerateAspectFileMap)) {
			return $this->_weaverGenerateAspectFileMap[$aspectName];
		}
		else {
			return null;
		}
	}
	
	public function getAspectFileMap() {
		return $this->_aspectFileMap;
	}
	
	public static function includeOnceAspect($aspectName) {
		$aspectManager = AOWP_AspectManager::getInstance();
		$aspectFilePath = $aspectManager->getAspectFilePath($aspectName);
		if ($aspectFilePath != null) {
			require_once $aspectFilePath;
			return true;
		}
		else {
			return false;
		}
	}
	
	public static function getInstance() {
		return unserialize(file_get_contents(AOWP_AspectManager::_getSerializationLocation()));
	}
	
	public static function getAllAspects() {
		$aspectManager = AOWP_AspectManager::getInstance();
		$allAspectInstanceArray = array();
		foreach ($aspectManager->_aspectFileMap as $aspectName => $aspectDefinitionPath) {
			if (include_once $aspectDefinitionPath) {
				$allAspectInstanceArray[] = new $aspectName;
			}
		}
		foreach ($aspectManager->_weaverGenerateAspectFileMap as $aspectName => $aspectDefinitionPath) {
			if (include_once $aspectDefinitionPath) {
				$allAspectInstanceArray[] = new $aspectName;
			}
		}
		return $allAspectInstanceArray;
	}
	
	public static function saveWeaverGenerateAspect($aspectName, $aspectSource) {
		if (!file_exists(AOWP_AspectManager::_getWeaverGenerateAspectFolderPath())) {
			AOWP_PHPFileManager::mkdir(AOWP_AspectManager::_getWeaverGenerateAspectFolderPath());
		}
		AOWP_Logger::setStartTime(10);
		$sourcePath = AOWP_AspectManager::_getWeaverGenerateAspectFolderPath() . $aspectName . '.aspect.php';
		file_put_contents($sourcePath, $aspectSource);
		$aspectManager = AOWP_AspectManager::getInstance();
		$aspectManager->addWeaverGenerateAspectFilePath($aspectName, $sourcePath);
		AOWP_AspectManager::_serialize($aspectManager);
		AOWP_Logger::logging('[Generate aspect] ' . $aspectName . '> ' . $sourcePath, 10);
	}
	public static function refleshWeaverGenerateAspect() {
		AOWP_PHPFileManager::removeFolder(AOWP_AspectManager::_getWeaverGenerateAspectFolderPath());
		AOWP_PHPFileManager::mkdir(AOWP_AspectManager::_getWeaverGenerateAspectFolderPath());
	}
	
}
?>