<?php
/**
 * @package aowp.aspect
 */
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'weaver' . DIRECTORY_SEPARATOR . 'PHPFileManager.class.php';
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'Logger.class.php';

/**
 * @package aowp.aspect
 */
class AOWP_ConfigurationManager {
	public static $WEAVING_TIME_FLAG = false;
	
	private static function _getConfigurationSamplePath() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . 'ConfigurationSample.class.php';
	}
	private static function _getConfigurationPath() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . 'Configuration.class.php';
	}
	private static function _getAOWPIncludePath() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'include.php';
	}
	
	public static function getCacheFolder() {
		return AOWP_ConfigurationManager::$WEAVING_TIME_FLAG ? AOWP_Configuration::WEAVING_DATA_FOLDER : AOWP_Configuration::RUNTIME_DATA_FOLDER . DIRECTORY_SEPARATOR . AOWP_Configuration::WAVING_DATA_DIR_NAME;
	}
	public static function includeAOWPClasses() {
		AOWP_Logger::setStartTime();
		require_once AOWP_ConfigurationManager::_getConfigurationPath();
		require_once AOWP_ConfigurationManager::_getAOWPIncludePath();
		AOWP_Logger::logging('[Include] Include AOWP classes.');
	}
	
	public static function getRuntimeDataFolder() {
		return $projectPath . DIRECTORY_SEPARATOR . $dataFolderName;
	}
	
	public static function setupRuntimeEnvironment() {
		if (file_exists(AOWP_Configuration::RUNTIME_DATA_FOLDER)) {
			AOWP_PHPFileManager::removeFolder(AOWP_Configuration::RUNTIME_DATA_FOLDER);
		}
		AOWP_PHPFileManager::mkdir(AOWP_Configuration::RUNTIME_DATA_FOLDER);
		AOWP_PHPFileManager::copy(AOWP_Configuration::WEAVING_DATA_FOLDER, AOWP_Configuration::RUNTIME_DATA_FOLDER);
		AOWP_PHPFileManager::copy(AOWP_Configuration::AOWP_CLASS_PATH . DIRECTORY_SEPARATOR . 'classes', AOWP_Configuration::RUNTIME_DATA_FOLDER);
	}
	
	/**
	 * This method generates and saves PHP file to define class for AOWP's configuration at weaving time and runtime.<br/>
	 * This method should be invoked before parsing PHP files and weaving defined aspects.
	 * 
	 * @param $aowpHome
	 * @param $projectPath
	 * @param $aspectPath
	 * @param $dataFolderName
	 * @param $includPattern
	 * @param $excludeFilePattern
	 */
	public static function setupConfiguration(
		$aowpHome,
		$projectPath,
		$aspectPath,
		$dataFolderName,
		$includPattern,
		$excludeFilePattern
	) {
		AOWP_Logger::setStartTime();
		$weavingDataFolder = $aowpHome . DIRECTORY_SEPARATOR . $dataFolderName;
		
		// Generate configuration files.
		$configSampleFilePath = AOWP_ConfigurationManager::_getConfigurationSamplePath();
		$sampleContent = file_get_contents($configSampleFilePath);
		$src = array(
			'%AOWP_CLASS_PATH%', 
			'%PROJECT_HOME_PATH%', 
			'%ASPECT_DIR_PATH%', 
			'%WEAVING_DATA_FOLDER%', 
			'%RUNTIME_DATA_FOLDER%', 
			'%INCLUDE_PHP_FILE_PATERN%', 
			'%EXCLUDE_PHP_FILE_PATERN%',
			'%WAVING_DATA_DIR_NAME%',
		);
		$dist = array(
			$aowpHome,
			$projectPath,
			$aspectPath,
			$aowpHome . DIRECTORY_SEPARATOR . $dataFolderName,
			$projectPath . DIRECTORY_SEPARATOR . $dataFolderName,
			$includPattern,
			$excludeFilePattern,
			$dataFolderName,
		);
		$configContent = str_replace($src, $dist, $sampleContent);
		$weavingConfigFilePath = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'Configuration.class.php';
		if (file_put_contents($weavingConfigFilePath, $configContent)) {
			AOWP_Logger::logging('[Setup configuration] Configuration class is created.');
		}
		else {
			AOWP_Logger::logging('[Setup configuration] Failed to save configuration file.');
		}
	}
	
}
?>