<?php
/**
 * Advice.class
 *
 * @package aowp.aspect.advice
 */
abstract class AOWP_Advice implements AOWP_IASTWalkable {

	const BEFORE          = 0;
	const AFTER           = 1;
	const AFTER_RETURNING = 2;
	const AFTER_THROWING  = 3;
	const AROUND          = 4;
	
	protected $_pointcut;
	protected $_type;
	protected $_index;
	protected $_executeFunction;
	protected $_adviceBodyFunctionName;
	protected $_adviceBodyInstance;
	protected $_classNameOfAspect;
	
	public function setPointcut($pointcut) 
	{
		$this->_pointcut = $pointcut;
	}
	
	public function getPointcut() {
		return $this->_pointcut;
	}
	
	public function setClassNameOfAspect($classNameOfAspectName)
	{
		$this->_classNameOfAspect = $classNameOfAspectName;
	}
	
	public function getClassNameOfAspect()
	{
		return $this->_classNameOfAspect;
	}
	
	public function setIndex($index)
	{
		$this->_index = $index;
	}
	
	public function getIndex()
	{
		return $this->_index;
	}
	
	/**
	 * @param String $functionName
	 * @param datatype paramname description
	 */
	public function setAdviceBody($functionName, $instance = null) 
	{
		$this->_adviceBodyFunctionName = $functionName;
		$this->_adviceBodyInstance = $instance; // Is this operation needed?
	}
	
	public function getAdviceBodyFunctionName()
	{
		return $this->_adviceBodyFunctionName;
	}
	
	public function match(AOWP_JoinPoint $joinPoint) 
	{
		return $this->_pointcut->match($joinPoint);
	}
	
	public function runtimeMatch(AOWP_Context $context) 
	{
		return $this->_pointcut->runtimeMatch($context);
	}
	
	public function weave(AOWP_JoinPoint $joinPoint) 
	{	
		$joinPoint->weave($this);
	}
	
	public function getType() 
	{
		return $this->_type;
	}
	
	/**
	 * Returns advice type to string.
	 * 
	 * @return String advice type
	 */
	public function getTypeToString ()
	{
		switch ($this->_type) {
		case AOWP_Advice::BEFORE:
			return 'BEFORE';
			
		case AOWP_Advice::AFTER:
			return 'AFTER';
			
		case AOWP_Advice::AFTER_RETURNING:
			return 'AFTER_RETURNING';
			
		case AOWP_Advice::AFTER_THROWING:
			return 'AFTER_THROWING';
			
		case AOWP_Advice::AROUND;
			return 'AROUND';
		}
	}
	
	public function getWeavedAST(AOWP_PHPElement $replaceAST = null) 
	{
		return new AOWP_PHPWovenElement($this->_classNameOfAspect, $this->_index, $replaceAST);
	}
	
	public function getChildrenForWalk()
	{
		return array();
	}
}
?>
