<?php
/**
 * ArrayGetJoinPoint.class
 */
class AOWP_ArrayGetJoinPoint extends AOWP_GetGroupJoinPoint implements AOWP_Builder {
	
	/**
	 * Constructor.
	 */
    public function __construct ($element) 
    {
    	parent::__construct($element);
    }
    
    public function getArrayName ()
    {
    	// Remove '$';
    	return preg_replace('/^(\$)/', '', AOWP_TemplateEngine::scriptToSource($this->_element->variable));
    }
    
    protected function _common ($pos)
    {
		$idx = $pos->getParentPropertyIndex();
		if ($idx==NO_ARRAY) $idx=0;
		
		return $idx;
    }
    
    public function getKeyName ()
    {
    	/**
		 * Returns null when an indexExpr isnot setted as follows.
		 * 
		 * 		list(, $hoge[]) = 'hoge'; 
		 */
    	if ( !isset($this->_element->indexExpr) )
    		return null;
    		
    	// Remove '$';
    	$keyName = preg_replace('/^(\$)/', '', AOWP_TemplateEngine::scriptToSource($this->_element->indexExpr));
    
    	// Remove head of "'" ;
    	$keyName = preg_replace('/^\'/', '', $keyName);
    
    	// Remove end of "'";
        $keyName = preg_replace('/\'$/', '', $keyName);
    	
    	return $keyName;
    }
    
    protected function _replace($statement)
	{
	}
	
	public function toString ()
	{
		return '$'.$this->getArrayName().'['.$this->getKeyName().']';
	}
	
	public function getKind () 
	{
		return 'ArrayGet';
	}
   	
	public function toSource (AOWP_Builder $builder, AOWP_Advice $advice)
	{
		// Builders for template.
		$class      = $advice->getClassNameOfAspect();
		$advIdx     = $advice->getIndex();
		$arrayName  = $builder->getArrayName();
		$keyName    = $builder->getKeyName();
		$aroundIdx  = $builder->aroundIdx;
		$aspIdx     = AOWP_UnusedVariableCreator::getIndex();
		$contextIdx = AOWP_UnusedVariableCreator::getIndex() + 1;
		
		// Weaving info.
		$jp	     = $this->toString();
		$jpKind  = $this->getKind();
		$advType = $advice->getTypeToString();
	
		// To source. Use above builders in follows template.
		include 'templates/ArrayGet.php';
	}
}
?>