<?php
/**
 * ArraySetJoinPoint.class
 */
class AOWP_ArraySetJoinPoint extends AOWP_SetGroupJoinPoint implements AOWP_Builder {
	
	/**
	 * Constructor.
	 */
    public function __construct ($element) 
    {
    	parent::__construct($element);
    }
    
    public function getArrayName ()
    {
    	// Remove '$';
    	return preg_replace('/^(\$)/', '', AOWP_TemplateEngine::scriptToSource($this->_element->variable));
    }
    
    public function getKeyName ()
    {
		/**
		 * Returns null when an indexExpr isnot setted as follows.
		 * 
		 * 		$hoge[] = 'hoge'; 
		 */
    	if ( !isset($this->_element->indexExpr) )
    		return null;
    		
    	// Remove '$';
    	$keyName = preg_replace('/^(\$)/', '', AOWP_TemplateEngine::scriptToSource($this->_element->indexExpr));
    
    	// Remove head of "'" ;
    	$keyName = preg_replace('/^\'/', '', $keyName);
    
    	// Remove end of "'";
        $keyName = preg_replace('/\'$/', '', $keyName);
    	
    	return $keyName;
    }
    
    public function toString ()
	{
		return '$'.$this->getArrayName().'['.$this->getKeyName().']';
	}
	
	public function getKind () 
	{
		return 'ArraySet';
	}
	
	public function toSource (AOWP_Builder $builder, AOWP_Advice $advice)
	{
		// Builders for template.
		$class      = $advice->getClassNameOfAspect();
		$advIdx     = $advice->getIndex();
		$keyIdx     = $builder->keyIdx;
		$aspIdx     = AOWP_UnusedVariableCreator::getIndex();
		$contextIdx = AOWP_UnusedVariableCreator::getIndex() + 1;
		$arrayName  = $builder->getArrayName();
	    $keyName    = $builder->getKeyName();
		
		// Weaving info.
		$jp	     = $this->toString();
		$jpKind  = $this->getKind();
		$advType = $advice->getTypeToString();
		
		// To source. Use above builders in follows template.
		include 'templates/ArraySet.php';
	}
}
?>