<?php
/**
 * CallGroupJoinPoint.class
 *
 * @package aowp.aspect.joinpoint
 */
abstract class AOWP_CallGroupJoinPoint extends AOWP_JoinPoint implements AOWP_IWeaver {
	
	/**
	 * Builders for template
	 */
	public $argumentIdx;
	public $aroundIdx;
	public $returnIdx;
	
	/**
	 * Constructor.
	 */
    protected function __construct ($callElement) 
    {
    	parent::__construct($callElement);
    }
	
	/**
     * Weave advice.
     */
    public function weave (AOWP_Advice $advice)
    {
    	if ($this->_weavedCounter->get(AOWP_Advice::AROUND)>0) 
		{
			return; // Target method call has'not exist.
		}
		
		$pos = AOWP_ASTConverter::getInsertableSpace($this->_element);
		$idx = $this->_common($pos);
    	switch ($advice->getType()) {
		case AOWP_Advice::BEFORE:
			$this->_beforeWeave($advice, $pos, $idx);
			break;
				
		case AOWP_Advice::AROUND:
			$this->_aroundWeave($advice, $pos, $idx);
			break;
				
		case AOWP_Advice::AFTER:
			$this->_afterWeave($advice, $pos, $idx);
			break;
		}
		
		$this->_weavedCounter->incl($advice->getType());
    }
    
	protected function _common ($pos)
	{
		if ($this->_weavedCounter->get(SUM)==0) 
		{
			$this->_insertArgumentsAssignmentStatements();
		}
		$idx = $pos->getParentPropertyIndex();
		if ( AOWP_ASTConverter::isNO_ARRAY($idx)) $idx=0;
		return $idx;
	}
	
	private function _beforeWeave(AOWP_Advice $advice, $pos, $idx)	
	{
		AOWP_ASTConverter::insertStatementAt($pos->getParent(), new AOWP_PHPWovenElement($this,$advice), $idx);
	}
	
	protected function _insertArgumentsAssignmentStatements()
	{
		$pos = AOWP_ASTConverter::getInsertableSpace($this->_element);
		$idx = $pos->getParentPropertyIndex();
		if ( AOWP_ASTConverter::isNO_ARRAY($idx)) $idx=0;
		
		$pos = $pos->getParent();
		$counter = AOWP_UnusedVariableCreator::getIndex();
		$this->argumentIdx = $counter;
		
		for($i=0; $i<$this->getArgumentsCount(); $i++) 
		{
			// Make arguments assignment statement
			$statement = AOWP_ASTConverter::createStatementWithUnusedVariable( ($counter+$i), $this->getArgumentNameAt($i) );
			AOWP_ASTConverter::insertStatementAt($pos, $statement, $idx+$i);

			// Replace original arguments with unused variables.
			$this->_replaceArgumentForStatement($this->_element, $statement, $i);
		}
		AOWP_UnusedVariableCreator::add($i);
	}
	
	private function _replaceArgumentForStatement ($elem, $statement, $idx)
	{
		$elem->arguments[$idx]->expr = AOWP_ASTConverter::getLeftExpr($statement);
	}
	
	private function _afterWeave(AOWP_Advice $advice, $pos, $idx) 
	{	
		if ($this->_weavedCounter->get(AOWP_Advice::AFTER)==0) 
		{
			$counter   = AOWP_UnusedVariableCreator::getIndex();
			$this->returnIdx = $counter;
		    $statement = $this->_getElementCallResultAssignmentStatement($counter);
		    $statement->setParentInfo($pos->getParent(), null, null);
		    
		    // Insert above statement.
		    AOWP_ASTConverter::insertStatementAt($pos->getParent(), $statement, $idx);

		    // Replace original function for the statement.
		    $this->_replaceOriginalElementFor($statement);
		 	
			// Set parent info.
			$this->_element->setParentInfo($statement->getParent(), null, $idx);
		
			// Next position of function call.
			$idx = $pos->getParentPropertyIndex() + 1;
			if ( AOWP_ASTConverter::isNO_ARRAY($idx)) $idx=0;
			
			AOWP_ASTConverter::updateParentInfo($pos->getParent());	
			AOWP_UnusedVariableCreator::add(1);
			
		} else {
			
			// Next position of the last weaved After advice.
			$idx += $this->_weavedCounter->get(AOWP_Advice::AFTER) + 1 + 1; //?
		}

		AOWP_ASTConverter::insertStatementAt($pos->getParent(), new AOWP_PHPWovenElement($this,$advice), $idx);
	}
	
	protected function _getElementCallResultAssignmentStatement ($counter)
	{
		return AOWP_ASTConverter::createStatementWithUnusedVariable($counter, $this->_element);
	}
	
	private function _aroundWeave(AOWP_Advice $advice, $pos, $idx) 
	{		
		$counter   = AOWP_UnusedVariableCreator::getIndex();
		$statement = AOWP_ASTConverter::createStatementWithUnusedVariable($counter, '$hoge');
		
		// If after advice inserted, the position of original element was moved.
		if ($this->_weavedCounter->get(AOWP_Advice::AFTER)>0){
			$this->_replace($statement);
		} else {	
			$this->_replaceOriginalElementFor($statement);
		}
		
		$this->aroundIdx = $counter;
		AOWP_UnusedVariableCreator::add(1);
		AOWP_ASTConverter::insertStatementAt($pos->getParent(), new AOWP_PHPWovenElement($this,$advice), $pos->getParentPropertyIndex());			
	}
}
?>