<?php
/**
 * ConstructorCallJoinPoint.class
 *
 * @package aowp.aspect.joinpoint
 */
class AOWP_ConstructorCallJoinPoint extends AOWP_CallGroupJoinPoint implements AOWP_Builder {
    
    /**
     * Constructor.
     */
	public function __construct ($element) 
	{
		parent::__construct($element);	
	}
	
	public function getClassName()
	{
		return $this->_element->className;
	}

	public function getArgumentNameAt ($idx) 
    {		
		return AOWP_TemplateEngine::scriptToSource($this->_element->arguments[$idx]);
	}
	
	public function getArgumentsCount()
	{
		return count($this->_element->arguments);
	}
	
	public function getArgumentNameAsArray() 
	{
		for($i=0; $i<$this->getArgumentsCount(); $i++) {
			$args[] = $this->getArgumentNameAt($i);
		}
		return $args;
	}
	
	protected function _replaceOriginalElementFor ($statement)
	{
		 AOWP_ASTConverter::replaceOriginalElementFor($this->_element, $statement, get_class($this->_element));
	}
	
	protected function _replace($statement)
	{
		$idx = $this->_element->getParentPropertyIndex();
		$statementsType = AOWP_ASTConverter::getStatementsType($this->_element->getParent());
		$pos = $this->_element->getParent()->{$statementsType}[$idx];			
		AOWP_ASTConverter::setRightExpr($pos, AOWP_ASTConverter::getLeftExpr($statement));
	}
	
	public function toString ()
	{
		if ( $this->getArgumentsCount()>0 ) {
			$argsLine = implode(',', $this->getArgumentNameAsArray() );
		} else {
			$argsLine = ' ';
		}
		
		return 'new '.$this->getClassName().'('.$argsLine.')';
	}
	
	public function getKind () 
	{
		return 'ConstructorCall';
	}
	
	public function toSource (AOWP_Builder $builder, AOWP_Advice $advice)
	{
		// Builders for template
		$class      = $advice->getClassNameOfAspect();
		$advIdx     = $advice->getIndex();
		$argsNum    = $builder->getArgumentsCount();
		$argsIdx    = $builder->argumentIdx;
		$aspIdx     = AOWP_UnusedVariableCreator::getIndex();
		$contextIdx = AOWP_UnusedVariableCreator::getIndex() + 1;
		
		switch ($advice->getType()) {
		case AOWP_Advice::BEFORE:
			break;
				
		case AOWP_Advice::AFTER:
			$retIdx = $builder->returnIdx;
			break;
				
		case AOWP_Advice::AROUND:
			$className  = $builder->getClassName();
			$aroundIdx  = $builder->aroundIdx;
			break;
		}
		
		// Weaving info.
		$jp	     = $this->toString();
		$jpKind  = $this->getKind();
		$advType = $advice->getTypeToString();
		
		// To source. Use above builders in follows template.
		include 'templates/ConstructorCall.php';
	}
}
?>