<?php
/**
 * ExecutionGroupJoinPoint.class
 *
 * @package aowp.aspect.joinpoint
 */
abstract class AOWP_ExecutionGroupJoinPoint extends AOWP_JoinPoint implements AOWP_IWeaver {
	
	/**
	 * Builders for template.
	 */
	public $argumentIdx = -1;
	public $returnIdx   = -1;
	public $originalFunctionName;
	
	/**
	 * Constructor.
	 */
    protected function __construct ($element) 
    {
    	parent::__construct($element);
    }
    
    /**
     * Weave advice.
     */
    public function weave (AOWP_Advice $advice)
    {
    	switch ($advice->getType()) {
		case AOWP_Advice::BEFORE:
			$this->_beforeWeave($advice);
			break;
				
		case AOWP_Advice::AROUND:
			$this->_aroundWeave($advice);
			break;
				
		case AOWP_Advice::AFTER:
			$this->_afterWeave($advice);
			break;
		}
		
		$this->_weavedCounter->incl($advice->getType());
    }

	protected function _beforeWeave(AOWP_Advice $advice) 
	{			
		AOWP_ASTConverter::insertStatementAt(
			$this->_element, new AOWP_PHPWovenElement($this, $advice), $this->_weavedCounter->get(AOWP_Advice::BEFORE));
	}
	
	protected function _afterWeave(AOWP_Advice $advice) 
	{	
		$retStaPos = AOWP_ASTConverter::getElementsByClassName($this->_element, 'AOWP_PHPReturnStatementElement');
		$this->_insertAfterAdviceAtReturnStatement($retStaPos, $advice); // Insert after advice to each return statements.
		$this->_appendAfterAdvice($advice);
	}
	
	private function _insertAfterAdviceAtReturnStatement ($returnStatementPos, $advice)
	{
		while (count($returnStatementPos)>0) 
		{
			$line   = array_shift($returnStatementPos); // AOWP_PHPReturnStatementElement
			$pos    = $line->getParent();
			$retIdx = $this->_hasInsertableSpace($line);
			
			$counter   = AOWP_UnusedVariableCreator::getIndex();
			$statement = AOWP_ASTConverter::createStatementWithUnusedVariable($counter, AOWP_ASTConverter::getExpr($line));
			
			// Replace original return statement for new statement.
			AOWP_ASTConverter::setStatementAt($pos, $statement, $retIdx);
			$this->returnIdx = $counter;
			
			// Append after advice element.
			AOWP_ASTConverter::appendStatement($pos, new AOWP_PHPWovenElement($this, $advice));
				
			// Append new return statement.
			$this->_appendNewReturnStatement($pos, $counter);
				
			AOWP_UnusedVariableCreator::add(1);
		}
	}
	
	private function _hasInsertableSpace ($line)
	{
		$retIdx=$line->getParentPropertyIndex();
		if ( AOWP_ASTConverter::isNO_ARRAY($retIdx))
		{
			$line->getParent()->innerStatements = array($line->getParent()->innerStatements); 
			return 0;
		}
		return $retIdx;
	}
	
	private function _appendNewReturnStatement ($pos, $counter)
	{
		$newRetStatement = AOWP_ASTConverter::createStatement(
				'return ${AOWP_UnusedVariableCreator::getUnusedVariableNameAt('.$counter.')};');
		AOWP_ASTConverter::appendStatement($pos, $newRetStatement);
	}
	
	private function _appendAfterAdvice ($advice)
	{
		if( !(($elem=AOWP_ASTConverter::getLastStatement($this->_element)) instanceof AOWP_PHPReturnStatementElement) ) 
		{
			AOWP_ASTConverter::appendStatement($this->_element, new AOWP_PHPWovenElement($this, $advice));
		}
	}
	
	protected function _aroundWeave (AOWP_Advice $advice) 
	{
		$pos = AOWP_ASTConverter::getInsertableSpace($this->_element);
		$originalFuncName = $this->_element->functionName;
		
		// Clone the original function.
		$cloneFunc = $this->_cloneOriginalFunction($pos);
		$this->originalFunctionName[] = $cloneFunc->functionName .= uniqid();
		
		// Insert clone function at.
		AOWP_ASTConverter::insertStatementAt($pos->getParent(), $cloneFunc, $pos->getParentPropertyIndex());
		
		// Replace the original function for around advice element.
		AOWP_ASTConverter::setStatements($this->_element, new AOWP_PHPWovenElement($this,$advice));
		
		// Append return statement for after advice.
		AOWP_ASTConverter::appendStatement($this->_element, AOWP_ASTConverter::createStatement('return $retVal;'));
		
		AOWP_ASTConverter::updateParentInfo($this->_element);
		AOWP_ASTConverter::updateParentInfo($this->_element->getParent());
	}
	
	private function _cloneOriginalFunction ($pos)
	{
		$cloneElem = clone $this->_element;
		$cloneElem->setParentInfo($this->_element->getParent(), innerStatements, 0);
		return $cloneElem;
	}
}
?>
