<?php
/**
 * FieldGetJoinPoint.class
 *
 * @package aowp.aspect.joinpoint
 */
class AOWP_FieldGetJoinPoint extends AOWP_GetGroupJoinPoint implements AOWP_Builder {
	
	/**
	 * Builders for template.
	 */
	public $fieldIdx;
	public $propIdx;
	public $propertiesLine;
	public $prePropertiesLine;
	
	/**
	 * Constructor.
	 */
    public function __construct ($element) 
    {
    	parent::__construct($element);
    }
    
    public function getFieldName ()
    {
    	return $this->_element->propertyName;
    }
    
    protected function _common ($pos)
    {
    	if (!isset($this->propertiesLine)) 
		{
			$this->propertiesLine    = AOWP_ASTConverter::getPropertiesLine($this->_element);
    		$this->prePropertiesLine = AOWP_ASTConverter::getPrePropertiesLine($this->_element);
		}
		
		$idx = $pos->getParentPropertyIndex();
		if ( AOWP_ASTConverter::isNO_ARRAY($idx)) $idx=0;
		
		if ($this->_weavedCounter->get(SUM)==0) 
		{
			$counter        = AOWP_UnusedVariableCreator::getIndex();
			$this->propIdx = $counter;
		    $statement      = AOWP_ASTConverter::createStatementWithUnusedVariable($counter, $this->prePropertiesLine);
			
			// Insert above statement.
		    AOWP_ASTConverter::insertStatementAt($pos->getParent(), $statement, $idx);

		    // Replace original pre propeties for the statement.
		    AOWP_ASTConverter::replacePrePropertiesWith($this->_element, $statement);
		 	
			// Next position of function call.
			$idx = $pos->getParentPropertyIndex() ; //?
			if ( AOWP_ASTConverter::isNO_ARRAY($idx)) $idx=0;
			
			AOWP_ASTConverter::updateParentInfo($pos->getParent());	
			AOWP_UnusedVariableCreator::add(1);
		}
		
		return $idx;
    }
   	
   	protected function _afterWeave (AOWP_Advice $advice, $pos, $idx)
   	{
    	if ($this->_weavedCounter->get(AOWP_Advice::AFTER)==0)
		{
			$counter   = AOWP_UnusedVariableCreator::getIndex();
			$this->fieldIdx = $counter;
			$statement = $this->_getElementReferenceStatement($counter);
			$statement->setParentInfo($pos->getParent(), null, null);
			
			AOWP_ASTConverter::replacePropertiesWith($this->_element, $statement);
		
			AOWP_ASTConverter::insertStatementAt($pos->getParent(), $statement, $idx);
			
			$this->_element->setParentInfo($statement->getParent(), null, $idx);
			$idx = $pos->getParentPropertyIndex() ; //?
			AOWP_UnusedVariableCreator::add(1);		
		}
    	
		AOWP_ASTConverter::insertStatementAt($pos->getParent(), new AOWP_PHPWovenElement($this,$advice), $idx); 
   	}
	
	protected function _getElementReferenceStatement ($counter)
	{
		$statement = AOWP_ASTConverter::createStatementWithUnusedVariable($counter);
		AOWP_ASTConverter::setRightExpr($statement, $this->_element->getParent()); // Give parent.
		return $statement;
	}
	
	protected function _replaceOriginalElementFor ($statement)
	{
		AOWP_ASTConverter::replacePropertiesWith($this->_element, $statement);
	}
	
	public function toString ()
	{
		return '$'.$this->getFieldName();
	}
	
	public function getKind () 
	{
		return 'FieldGet';
	}
	
	public function toSource (AOWP_Builder $builder, AOWP_Advice $advice)
	{
		// Builders for template.
		$class      = $advice->getClassNameOfAspect();
		$advIdx     = $advice->getIndex();
		$fieldIdx   = $builder->fieldIdx;
		$propIdx    = $builder->propIdx;
		$aroundIdx  = $builder->aroundIdx;
		$aspIdx     = AOWP_UnusedVariableCreator::getIndex();
		$contextIdx = AOWP_UnusedVariableCreator::getIndex() + 1;
		$fieldName  = $builder->getFieldName();
		
		// Weaving info.
		$jp	     = $this->toString();
		$jpKind  = $this->getKind();
		$advType = $advice->getTypeToString();
		
		// To source. Use above builders in follows template.
		include 'templates/FieldGet.php';
	}
}
?>