<?php
/**
 * FieldSetJoinPoint.class
 *
 * @package aowp.aspect.joinpoint
 */
class AOWP_FieldSetJoinPoint extends AOWP_SetGroupJoinPoint implements AOWP_Builder {
	
	/**
	 * Builders for template.
	 */
	public $fieldIdx;
	public $propIdx;
	public $propertiesLine;
	public $prePropertiesLine;
	
	/**
	 * Constructor.
	 */
    public function __construct ($element) 
    {
    	parent::__construct($element);
    }
    
    public function getFieldName ()
    {
    	/**
    	 * Example :
    	 * field is array.
    	 * 
    	 * $obj->hoge[]
    	 */
    	if ( $this->_element->propertyName instanceof AOWP_PHPReferenceVariableElement ) {
    		
    		return AOWP_TemplateEngine::scriptToSource($this->_element->propertyName);
//    		return $this->_element->propertyName->variable;
    	} 
    	
    	return $this->_element->propertyName;
    }
    
    protected function _common ($pos)
    {
    	$this->fieldIdx = AOWP_UnusedVariableCreator::getIndex();
    	
    	if ($this->_weavedCounter->get(SUM) == 0) {
			$this->_insertFieldSetStatement($pos);
		}
		
		if (!isset($this->propertiesLine)) 
		{
			$this->propertiesLine    = AOWP_ASTConverter::getPropertiesLine($this->_element);
    		$this->prePropertiesLine = AOWP_ASTConverter::getPrePropertiesLine($this->_element);
		}
		
		$idx = $pos->getParentPropertyIndex();
		if ( AOWP_ASTConverter::isNO_ARRAY($idx)) $idx=0;
		
		if ($this->_weavedCounter->get(SUM)==0) 
		{
			$counter       = AOWP_UnusedVariableCreator::getIndex();
			$this->propIdx = $counter;
		    $statement     = AOWP_ASTConverter::createStatementWithUnusedVariable($counter, $this->prePropertiesLine);
			
			// Insert above statement.
		    AOWP_ASTConverter::insertStatementAt($pos->getParent(), $statement, $idx);

		    // Replace original pre propeties for the statement.
		    AOWP_ASTConverter::replacePrePropertiesWith($this->_element, $statement);
		 	
			// Next position of function call.
			$idx = $pos->getParentPropertyIndex(); //?
			if ( AOWP_ASTConverter::isNO_ARRAY($idx)) $idx=0;
			
			AOWP_ASTConverter::updateParentInfo($pos->getParent());	
			AOWP_UnusedVariableCreator::add(1);
		}
		
		return $idx;
    }
    
	protected function _insertFieldSetStatement (AOWP_PHPElement $pos)
	{
		$counter   = AOWP_UnusedVariableCreator::getIndex();
		$statement = AOWP_ASTConverter::createStatementWithUnusedVariable($counter);
		$temp      = $this->_element->getParent()->getParent()->expr;
		
		$this->_element->getParent()->getParent()->expr = AOWP_ASTConverter::getLeftExpr($statement); 
		AOWP_ASTConverter::setRightExpr($statement, $temp);
		
		AOWP_ASTConverter::insertStatementAt($pos->getParent(), $statement, $pos->getParentPropertyIndex());
		AOWP_UnusedVariableCreator::add(1);	
	}
	
	public function toString ()
	{
		return '$'.$this->getFieldName();
	}
	
	public function getKind () 
	{
		return 'FieldSet';
	}
	
	public function toSource (AOWP_Builder $builder, AOWP_Advice $advice)
	{
		// Builders for template.
		$class      = $advice->getClassNameOfAspect();
		$advIdx     = $advice->getIndex();
		$argsIdx    = $builder->argumentIdx;
		$fieldIdx   = $builder->fieldIdx;
		$propIdx    = $builder->propIdx;
		
//		/**
//		 * If field name includes array which indexExpr is unset.
//		 */
//		$fieldName  = $builder->getFieldName();
		
		$aspIdx     = AOWP_UnusedVariableCreator::getIndex();
		$contextIdx = AOWP_UnusedVariableCreator::getIndex() + 1;
		
		// Weaving info.
		$jp	     = $this->toString();
		$jpKind  = $this->getKind();
		$advType = $advice->getTypeToString();
		
		// To source. Use above builders in follows template.
		include 'templates/FieldSet.php';
	}
}
?>