<?php
/**
 * GlobalVariableGet.class
 */
class AOWP_GlobalVariableGetJoinPoint extends AOWP_GetGroupJoinPoint implements AOWP_Builder {
	
	/**
	 * Constructor.
	 */
	public function __construct ($element)
	{
		parent::__construct($element);
	}
	
	public function getVariableName ()
	{
    	return preg_replace('/^(\$)/', '', AOWP_TemplateEngine::scriptToSource($this->_element));
    }
    
    protected function _common ($pos)
    {
		$idx = $pos->getParentPropertyIndex();
		if ($idx==NO_ARRAY) $idx=0;
		
		return $idx;
    }
	
	protected function _replace($statement)
	{
	}
	
	public function toString ()
	{
		return '$'.$this->getVariableName();
	}
	
	public function getKind () 
	{
		return 'GlobalVariableGet';
	}
	
	public function toSource (AOWP_Builder $builder, AOWP_Advice $advice)
	{
		// Builders for template.
		$class      = $advice->getClassNameOfAspect();
		$advIdx     = $advice->getIndex();
		$aspIdx     = AOWP_UnusedVariableCreator::getIndex();
		$contextIdx = AOWP_UnusedVariableCreator::getIndex() + 1;
		$valName    = $builder->getVariableName();
		$aroundIdx  = $builder->aroundIdx;
		
		// Weaving info.
		$jp	     = $this->toString();
		$jpKind  = $this->getKind();
		$advType = $advice->getTypeToString();
		
		// To source. Use above builders in follows template.
		include 'templates/GlobalVariableGet.php';
	}
}
?>