<?php
/**
 * GlobalVariableSet.class
 */
class AOWP_GlobalVariableSetJoinPoint extends AOWP_SetGroupJoinPoint implements AOWP_Builder {
	
	/**
	 * Constructor.
	 */
	public function __construct ($element)
	{
		parent::__construct($element);
	}
	
	public function getVariableName ()
	{
    	return preg_replace('/^(\$)/', '', AOWP_TemplateEngine::scriptToSource($this->_element));
    }
    
    public function toString ()
	{
		return '$'.$this->getVariableName();
	}
	
	public function getKind () 
	{
		return 'GlobalVariableSet';
	}
	
    public function toSource (AOWP_Builder $builder, AOWP_Advice $advice)
	{
		// Builders for template.
		$class      = $advice->getClassNameOfAspect();
		$advIdx     = $advice->getIndex();
		$aspIdx     = AOWP_UnusedVariableCreator::getIndex();
		$contextIdx = AOWP_UnusedVariableCreator::getIndex() + 1;
		$keyIdx     = $builder->keyIdx;
		$valName    = $builder->getVariableName();
		
		// Weaving info.
		$jp	     = $this->toString();
		$jpKind  = $this->getKind();
		$advType = $advice->getTypeToString();
		
		// To source. Use above builders in follows template.
		include 'templates/GlobalVariableSet.php';
	}
}
?>