<?php
/**
 * JoinPoint.class
 *
 * @package aowp.aspect.joinpoint
 */
abstract class AOWP_JoinPoint implements AOWP_IASTWalkable {
	
	const SUM    = 0;
	const BEFORE = 1;
	const AFTER  = 2;
	const AROUND = 3;
	
	/**
	 * Target AST element.
	 */
	protected $_element;
	
	/**
	 * Counter of wevae.
	 */
	protected $_weavedCounter;
	
	/**
	 * Debugging 
	 */
	protected $_debug = false;
	
	/**
	 * Belongs class.
	 */
	private $_belongClass;
	
	/**
	 * Belongs method.
	 */
	private $_belongMethod;
	
	/**
	 * Location.
	 */
	private $_location;
	
	/**
	 * Returns join point to string.
	 */
	abstract public function toString ();
	
	/**
	 * Returns join point kind.
	 */
	abstract public function getKind ();
	
	/**
	 * Constructor.
	 * 
	 * @param AOWP_PHPElement $element
	 */
	protected function __construct ($elem)
	{
		if ($this->_debug) 
		{
			echo 'AOWP_JoinPoint : '.$this->getKind().'<br/>';
		}
		
		$this->_element = $elem;
		$this->_weavedCounter = new AOWP_WeavedCounter();
		$this->_setBelongClass();
		$this->_setBelongMethod();
	}
    
    /**
     * Returns belong class name.
     * 
     * @return String class name
     */
    final public function getBelongClassName ()
    {	 
   		 if ( $this->_belongClass!=null ) {
   		 	return $this->_belongClass->className;
   		 } else {
   		 	return null;
   		 }
    }
    
    final private function _setBelongClass ()
    {
    	for ( $pos=$this->_element; !($pos instanceof AOWP_PHPRootElement); $pos = $pos->getParent()) 
    	{
    		if ( $pos instanceof AOWP_PHPClassElement ) 
    		{
    			$this->_belongClass = $pos;
    			return;
    		}
    	}
    	
    	$this->_belongClass = null;
    }
    
    /**
     * Returns belong method name.
     * 
     * @return String method name.
     */
    final public function getBelongMethodName ()
    {
   		if ( $this->_belongMethod!=null ) {
   			return $this->_belongMethod->functionName;
   		} else {
   			return null;
   		}
    }
    
    /**
     * Returns belong arguments count
     * 
     * @return int arguments num
     */
    final public function getBelongMethodArgumentsCount ()
    {
   		if ( $this->_belongMethod!=null ) {
   			return count($this->_belongMethod->paramaters);
   		} else {
   			return -1;
   		}
    }
    
    /**
     * Returns belong method modifiers
     * 
     * @return String modifiers
     */
    final public function getBelongMethodModifiers ()
    {
		if ( $this->_belongMethod!=null	)
			return implode(' ',$this->_belongMethod->modifiers);
		else {
			return null;
		}
    }
    
    final private function _setBelongMethod ()
    {
    	for ( $pos=$this->_element; !AOWP_ASTUtility::isNullElement($pos); $pos = $pos->getParent()) 
    	{
    		if ( $pos instanceof AOWP_PHPMethodElement ) 
    		{
    			$this->_belongMethod = $pos;
    			return;
    		}
    	}
    	
    	$this->_belongMethod = null;
    }
    
	public function getChildrenForWalk ()
	{
		return array();
	}
}
?>
