<?php
/**
 * MethodCallJoinPoint.class
 *
 * @package aowp.aspect.joinpoint
 */
class AOWP_MethodCallJoinPoint extends AOWP_CallGroupJoinPoint implements AOWP_Builder {
	private $_methodName;
	
	/**
	 * Builders for template
	 */
	public $propIdx;
	public $propertiesLine;
	public $prePropertiesLine;
	
	/**
	 * Constructor.
	 */
	public function __construct($methodCallElement) 
	{
		parent::__construct($methodCallElement);
	}
	
	public function getMethodName()
	{
		return $this->_element->propertyName;
	}
	
	public function getArgumentNameAt ($idx) 
    {		
		return AOWP_TemplateEngine::scriptToSource($this->_element->arguments[$idx]);
	}
	
	public function getArgumentsCount()
	{
		return count($this->_element->arguments);
	}
	
	public function getArgumentNameAsArray() 
	{
		for($i=0; $i<$this->getArgumentsCount(); $i++) {
			$args[] = $this->getArgumentNameAt($i);
		}
		return $args;
	}
	
	protected function _common ($pos)
	{
		if ($this->_weavedCounter->get(SUM)==0) 
		{
			$this->_insertArgumentsAssignmentStatements();
		}
		
		if (!isset($this->propertiesLine))
		{
			$this->propertiesLine    = AOWP_ASTConverter::getPropertiesLine($this->_element);
			$this->prePropertiesLine = AOWP_ASTConverter::getPrePropertiesLine($this->_element);
		}
		
		$idx = $pos->getParentPropertyIndex();
		if ( AOWP_ASTConverter::isNO_ARRAY($idx)) $idx=0;
		
		if ($this->_weavedCounter->get(SUM)==0) 
		{
			$counter       = AOWP_UnusedVariableCreator::getIndex();
			$this->propIdx = $counter;
		    $statement     = AOWP_ASTConverter::createStatementWithUnusedVariable($counter, $this->prePropertiesLine);
			
			// Insert above statement which represents assignment of instance.
		    AOWP_ASTConverter::insertStatementAt($pos->getParent(), $statement, $idx);

		    // Replace original pre propeties for the statement.
		    AOWP_ASTConverter::replacePrePropertiesWith($this->_element, $statement);
		 	
			// Next position of function call.
			$idx = $pos->getParentPropertyIndex(); //?
			if ( AOWP_ASTConverter::isNO_ARRAY($idx)) $idx=0;
			AOWP_ASTConverter::updateParentInfo($pos->getParent());	
			AOWP_UnusedVariableCreator::add(1);
		}
		
		return $idx;
	}
	
	protected function _replaceOriginalElementFor ($statement)
	{
		AOWP_ASTConverter::replacePropertiesWith($this->_element, $statement);
	}
	
	protected function _getElementCallResultAssignmentStatement ($counter)
	{
		return AOWP_ASTConverter::createStatementWithUnusedVariable($counter, $this->_element->getParent());
	}
	
	protected function _replace($statement)
	{
		$idx = $this->_element->getParentPropertyIndex();
		$statementsType = AOWP_ASTConverter::getStatementsType($this->_element->getParent());
		$pos = $this->_element->getParent()->{$statementsType}[$idx];			
		AOWP_ASTConverter::setRightExpr($pos, AOWP_ASTConverter::getLeftExpr($statement));
	}
	
	public function toString ()
	{
		if ( $this->getArgumentsCount()>0 ) {
			$argsLine = implode(',', $this->getArgumentNameAsArray() );
		} else {
			$argsLine = ' ';
		}
		
		return $this->getMethodName().'('.$argsLine.')';
	}
	
	public function getKind () 
	{
		return 'MethodCall';
	}
	
	public function toSource (AOWP_Builder $builder, AOWP_Advice $advice)
	{
		// Builders for template
		$class      = $advice->getClassNameOfAspect();
		$advIdx     = $advice->getIndex();
		$argsNum    = $builder->getArgumentsCount();
		$argsIdx    = $builder->argumentIdx;
		$propIdx    = $builder->propIdx;
		$aspIdx     = AOWP_UnusedVariableCreator::getIndex();
		$contextIdx = AOWP_UnusedVariableCreator::getIndex() + 1;
		
		switch ($advice->getType()){
		case AOWP_Advice::BEFORE:
			break;
				
		case AOWP_Advice::AFTER:
			$retIdx = $builder->returnIdx;
			break;
				
		case AOWP_Advice::AROUND:
			$methodName = $builder->getMethodName();
			$aroundIdx  = $builder->aroundIdx;
			break;
		}
		
		// Weaving info.
		$jp	     = $this->toString();
		$jpKind  = $this->getKind();
		$advType = $advice->getTypeToString();
		
		// To source. Use above builders in follows template.
		include 'templates/MethodCall.php';
	}
}
?>