<?php
/**
 * MethodExecutionJoinPoint.class
 *
 * @package aowp.aspect.joinpoint
 */
class AOWP_MethodExecutionJoinPoint extends AOWP_ExecutionGroupJoinPoint implements AOWP_Builder {	
	
	/**
	 * Constructor.
	 */
	public function __construct (AOWP_PHPMethodElement $methodElement)
	{
		parent::__construct($methodElement);
	}
	
	public function getModifiers ()
	{
		return $this->getBelongMethodModifiers();
	}
	
	public function getClassName () 
	{
		return $this->getBelongClassName();
	}
	
	public function getMethodName()
	{
		return $this->getBelongMethodName();
	}
	
	public function getArgumentNameAt($idx) 
	{		
		return $this->_element->paramaters[$idx]->paramaterName->variableName;
	}
	
	public function getArgumentsCount() 
	{
		return $this->getBelongMethodArgumentsCount();
	}
	
	public function getArgumentNameAsArray() 
	{
		for($i=0; $i<$this->getArgumentsCount(); $i++) {
			$args[] = $this->getArgumentNameAt($i);
		}
		return $args;
	}
	
	public function toString ()
	{
		if ( $this->getArgumentsCount()>0 ) {
			$argsLine = implode(',', $this->getArgumentNameAsArray() );
		} else {
			$argsLine = ' ';
		}
		
		return $this->getMethodName().'('.$argsLine.')';
	}
	
	public function getKind () 
	{
		return 'MethodExecution';
	}
	
	public function toSource (AOWP_Builder $builder, AOWP_Advice $advice)
	{
		// Builders of template.
		$class      = $advice->getClassNameOfAspect();
		$advIdx     = $advice->getIndex();
		$aspIdx     = AOWP_UnusedVariableCreator::getIndex();
		$contextIdx = AOWP_UnusedVariableCreator::getIndex() + 1;
		
		switch ($advice->getType()){
		case AOWP_Advice::BEFORE:		
			break;
				
		case AOWP_Advice::AFTER:
			$retIdx = -1;
			if ($builder->returnIdx!=-1) {
				$retIdx = $builder->returnIdx;
			}
			break;
				
		case AOWP_Advice::AROUND:
			$funcName = array_shift($builder->originalFunctionName);
			break;
		}
		
		// Weaving info.
		$jp	     = $this->toString();
		$jpKind  = $this->getKind();
		$advType = $advice->getTypeToString();
		
		// To source. Use above builders in follows template.
		include 'templates/MethodExecution.php';
	}
}
?>
