<?php
/**
 * ScriptCallJoinPoint.class
 *
 * @package aowp.aspect.joinpoint
 */
class AOWP_ScriptCallJoinPoint extends AOWP_CallGroupJoinPoint implements AOWP_Builder {
	private $_scriptName;
	
	/**
	 * Constructor.
	 */
	public function __construct ($element) 
	{
		parent::__construct($element);
	}
	
	public function getScriptName ()
	{
		$scrName = AOWP_TemplateEngine::scriptToSource($this->_element->expr);
		
		// Remove head of "'" ;
    	$scrName = preg_replace('/^\'/', '', $scrName);
    
    	// Remove tail of "'";
        $scrName = preg_replace('/\'$/', '', $scrName);
        
		return $scrName;
	}
	
	public function getScriptCallType ()
	{
		return $this->_element->type;
	}
	
	protected function _common ($pos)
	{
		$idx = $pos->getParentPropertyIndex();
		if ($idx==NO_ARRAY) $idx=0;
		return $idx;
	}
	
	protected function _replaceOriginalElementFor ($statement)
	{
		 AOWP_ASTConverter::replaceOriginalElementFor($this->_element, $statement, get_class($this->_element));
	}
	
	protected function _replace($statement)
	{
		$idx = $this->_element->getParentPropertyIndex();
		$statementsType = AOWP_ASTConverter::getStatementsType($this->_element->getParent());
		$pos = $this->_element->getParent()->{$statementsType}[$idx];			
		AOWP_ASTConverter::setRightExpr($pos, AOWP_ASTConverter::getLeftExpr($statement));
	}
	
	public function toString ()
	{
		return $this->getScriptCallType().' \''.$this->getScriptName().'\'';
	}
	
	public function getKind () 
	{
		return 'ScriptCall';
	}
	
	public function toSource (AOWP_Builder $builder, AOWP_Advice $advice)
	{
		// Builders of template.
		$class      = $advice->getClassNameOfAspect();
		$advIdx     = $advice->getIndex();
		$argsIdx    = $builder->argumentIdx;
		$aspIdx     = AOWP_UnusedVariableCreator::getIndex();
		$contextIdx = AOWP_UnusedVariableCreator::getIndex() + 1;
		
		switch ($advice->getType()){
		case AOWP_Advice::BEFORE:
			break;
				
		case AOWP_Advice::AFTER:
			$retIdx = -1;
			if ($builder->returnIdx!=-1) {
				$retIdx = $builder->returnIdx;
			}
			break;
				
		case AOWP_Advice::AROUND:
			$scriptCallType = $builder->getScriptCallType();
			$scriptName     = $builder->getScriptName();
			$aroundIdx      = $builder->aroundIdx;
			break;
		}
		
		// Weaving info.
		$jp	     = $this->toString();
		$jpKind  = $this->getKind();
		$advType = $advice->getTypeToString();
		
		// To source. Use above builders in follows template.
		include 'templates/ScriptCall.php';
	}
}
?>