<?php
/**
 * ScriptExecutionJoinPoint.class
 *
 * @package aowp.aspect.joinpoint
 */
class AOWP_ScriptExecutionJoinPoint extends AOWP_ExecutionGroupJoinPoint implements AOWP_Builder {
	private $_scriptName;
	
	/**
	 * Builders for template.
	 */
	public $underParen;
	
	/**
	 * Constructor.
	 */
	public function __construct(AOWP_PHPRootElement $rootElement, $scriptName) 
	{
		parent::__construct($rootElement);
		$this->_scriptName = $scriptName;
	}
	
	public function getScriptName() 
	{
		return $this->_scriptName;
	}
	
	protected function _afterWeave(AOWP_Advice $advice) 
	{
		AOWP_ASTConverter::appendStatement($this->_element, new AOWP_PHPWovenElement($this, $advice));
	}
	
	protected function _aroundWeave(AOWP_Advice $advice) 
	{
		$aroundAdvice = new AOWP_PHPWovenElement($this, $advice);
		AOWP_ASTConverter::insertStatementAt($this->_element, $aroundAdvice, 0);
		AOWP_ASTConverter::updateParentInfo($this->_element);
		$closingParenthesis = new AOWP_PHPWovenElement($this, $advice, 1);
		AOWP_ASTConverter::appendStatement($this->_element, $closingParenthesis);
	}
	
	
	public function toString ()
	{
		return 'script : '.$this->getScriptName();
	}
	
	public function getKind () 
	{
		return 'ScriptExecution';
	}
	
	public function toSource (AOWP_Builder $builder, AOWP_Advice $advice, $aroundHeaderOrFooterFlag = 0)
	{
		// Builders of template.
		$class  = $advice->getClassNameOfAspect();
		$advIdx = $advice->getIndex();
		
		// Weaving info.
		$jp	     = $this->toString();
		$jpKind  = $this->getKind();
		$advType = $advice->getTypeToString();

		$scriptName = $this->_scriptName;
		
		// To source. Use above builders in follows template.
		include 'templates/ScriptExecution.php';
	}
}
?>