<?php
/**
 * SetGroupJoinPoint.class
 */
abstract class AOWP_SetGroupJoinPoint extends AOWP_JoinPoint implements AOWP_IWeaver {
	
	/**
	 * Builders for template
	 */
	public $aroundIdx;
	public $keyIdx;
	
	/**
	 * Constructor.
	 */
    protected function __construct ($element) 
    {
    	parent::__construct($element);
    }
    
    /**
     * Weave advice.
     */
    public function weave (AOWP_Advice $advice)
    {
		if ($this->_weavedCounter->get(AOWP_Advice::AROUND) > 0) 
		{
			return; // Target method call has'not exist.
		}
		$pos = AOWP_ASTConverter::getInsertableSpace($this->_element);
		$idx = $this->_common($pos);
		
    	switch ($advice->getType()) {
			case AOWP_Advice::BEFORE:
				$this->_beforeWeave($advice, $pos, $idx);
				break;
					
			case AOWP_Advice::AROUND:
				$this->_aroundWeave($advice, $pos, $idx);
				break;
					
			case AOWP_Advice::AFTER:
				$this->_afterWeave($advice, $pos, $idx);
				break;
		}
		
		$this->_weavedCounter->incl($advice->getType());
    }
    
    protected function _common($pos) {
    	$this->keyIdx = AOWP_UnusedVariableCreator::getIndex();
    	if ($this->_weavedCounter->get(SUM) == 0) {
			$this->_insertAssignmentValueSetStatement($pos);
		}
		$idx = $pos->getParentPropertyIndex();
		if ( AOWP_ASTConverter::isNO_ARRAY($idx)) {
			$idx = 0;
		}
		return $idx;
    }
    
    protected function _insertAssignmentValueSetStatement ($pos)
	{
		$counter   = AOWP_UnusedVariableCreator::getIndex();
		$statement = AOWP_ASTConverter::createStatementWithUnusedVariable($counter);
//	 	$statement->setParentInfo($pos->getParent(), null, null);
		
		// cf. $$val = 'hoge';
		if ($this->_element->getParent() instanceof AOWP_PHPIndirectVariableElement)
		{
			$temp = $this->_element->getParent()->getParent()->expr;
			
			// replace assignment value for unused variable.
			$this->_element->getParent()->getParent()->expr = AOWP_ASTConverter::getLeftExpr($statement); 
		}
		// cf. $val = 'hoge';
		else
		{
			$temp = $this->_element->getParent()->expr;
			
			// replace assignment value for unused variable.
			$this->_element->getParent()->expr = AOWP_ASTConverter::getLeftExpr($statement); 
		}
		
//		$this->_element->setParentInfo($statement->getParent(), null, $pos->getParentPropertyIndex());
		
		AOWP_ASTConverter::setRightExpr($statement, $temp);
		AOWP_ASTConverter::insertStatementAt($pos->getParent(), $statement, $pos->getParentPropertyIndex());
		AOWP_UnusedVariableCreator::add(1);	
	}
	
	protected function _beforeWeave (AOWP_Advice $advice, $pos, $idx)
    {
		
		AOWP_ASTConverter::insertStatementAt($pos->getParent(), new AOWP_PHPWovenElement($this,$advice), $idx);
    }
  
    protected function _afterWeave (AOWP_Advice $advice, $pos, $idx)
    {
		$idx = $pos->getParentPropertyIndex()+$this->_weavedCounter->get(AOWP_Advice::AFTER)+1;
		AOWP_ASTConverter::insertStatementAt($pos->getParent(), new AOWP_PHPWovenElement($this,$advice), $idx); 
    }
    
    protected function _aroundWeave (AOWP_Advice $advice, $pos, $idx)
	{
		$counter   = AOWP_UnusedVariableCreator::getIndex();
    	$statement = AOWP_ASTConverter::createStatementWithUnusedVariable($counter);
    	
    	// Replace original element
    	$this->_element->getParent()->variable = AOWP_ASTConverter::getLeftExpr($statement);
    	$this->aroundIdx = $counter;
		
		// Insert around advice
		$this->_insertAroundAdvice(new AOWP_PHPWovenElement($this,$advice), $pos);
		
		AOWP_UnusedVariableCreator::add(1);	
	}
	
	protected function _insertAroundAdvice ($aroundAdvice, $pos)
	{
		
		AOWP_ASTConverter::insertStatementAt($pos->getParent(), $aroundAdvice, $pos->getParentPropertyIndex()+1); 
	}
}
?>