<?php
/**
 * ArrayGetPointcut.class
 */
class AOWP_ArrayGetPointcut extends AOWP_Pointcut {
	private $_arrayName;
	private $_keyName;

	/**
	 * Constructor.
	 */
	public function __construct ($arrayName, $keyName)
	{
		$this->_arrayName = $arrayName;
		$this->_keyName   = $keyName;
	}
	
	public function specificMatch(AOWP_JoinPoint $joinPoint)
	{	
		return 
		( 
			$joinPoint instanceof AOWP_ArrayGetJoinPoint &&
			AOWP_PointcutMatcher::match($this->_arrayName, $joinPoint->getArrayName()) &&
			AOWP_PointcutMatcher::match($this->_keyName, $joinPoint->getKeyName())
		);
	}
	
	public function runtimeSpecificMatch(AOWP_Context $context) 
	{
		return true;
	}
}
?>