<?php
/**
 * ArraySetPointcut.class
 */
class AOWP_ArraySetPointcut extends AOWP_Pointcut {
	private $_arrayName;
	private $_keyName;

	/**
	 * Constructor.
	 */
	public function __construct ($arrayName, $keyName)
	{
		$this->_arrayName  = $arrayName;
		$this->_keyName    = $keyName;
	}
	
	public function specificMatch(AOWP_JoinPoint $joinPoint)
	{	
		return 
		( 
			$joinPoint instanceof AOWP_ArraySetJoinPoint &&
			AOWP_PointcutMatcher::match($this->_arrayName, $joinPoint->getArrayName()) &&
			AOWP_PointcutMatcher::match($this->_keyName, $joinPoint->getKeyName())
		);
	}
	
	public function runtimeSpecificMatch(AOWP_Context $context) 
	{
		return true;
	}
}
?>