<?php
/**
 * ConstructorCallPointcut.class
 * 
 * @package aowp.aspect.pointcut
 */
class AOWP_ConstructorCallPointcut extends AOWP_Pointcut {
	private $_className;
	private $_argumentScount;

	/**
	 * Constructor.
	 *
	 * @param String $methodPat method pattern.
	 */
	public function __construct ($className, $argumentsCount)
	{
		$this->_className      = $className;
		$this->_argumentsCount = $argumentsCount;
	}
	
	public function specificMatch(AOWP_JoinPoint $joinPoint)
	{	
		return 
		( 
			get_class($joinPoint)==AOWP_ConstructorCallJoinPoint) &&
			AOWP_PointcutMatcher::match($this->_className, $joinPoint->getClassName()) &&
			(($this->_argumentsCount==-1) || ($this->_argumentsCount==$joinPoint->getArgumentsCount())
		);
	}
	
	public function runtimeSpecificMatch(AOWP_Context $context) 
	{
		return true;
	}
}
?>
