<?php
/**
 * FieldSetPointcut.class
 * 
 * @package aowp.aspect.pointcut
 */
class AOWP_FieldSetPointcut extends AOWP_Pointcut {
    private $_className;
    private $_fieldName;
	
	/**
	 * Constructor.
	 */
    public function __construct($className, $fieldName) 
    {
    	parent::__construct();
    	$this->_className = $className;
    	$this->_fieldName = $fieldName;
    }
   
    public function specificMatch(AOWP_JoinPoint $joinPoint)
    {    	
    	return 
    	( 
    		get_class($joinPoint)==AOWP_FieldSetJoinPoint) &&
    		AOWP_PointcutMatcher::match($this->_fieldName, $joinPoint->getFieldName()
    	);
    }

	public function runtimeSpecificMatch(AOWP_Context $context) 
	{
		return AOWP_PointcutMatcher::match($this->_className, get_class($context->instance));
	}
}
?>