<?php
/**
 * FunctionCallPointcut.class
 * 
 * @package aowp.aspect.pointcut
 */
class AOWP_FunctionCallPointcut extends AOWP_Pointcut {
	private $_functionName;
	private $_argumentsCount;

	/**
	 * Constructor.
	 */
	public function __construct ($functionName, $argumentsCount) 
	{
		$this->_functionName   = $functionName;
		$this->_argumentsCount = $argumentsCount;
	}

	public function specificMatch(AOWP_JoinPoint $joinPoint)
	{
		return 
		( 
			get_class($joinPoint)==AOWP_FunctionCallJoinPoint) &&
			AOWP_PointcutMatcher::match($this->_functionName, $joinPoint->getFunctionName()) &&
			(($this->_argumentsCount==-1) || ($this->_argumentsCount==$joinPoint->getArgumentsCount())
		);
	}
	
	public function runtimeSpecificMatch(AOWP_Context $context) 
	{
		return true;
	}
}
?>
