<?php
class AOWP_GeneratedAspectNameManager {
	
	private static $_instance = null;
	private $_observationAspectNameMap;

	public function __construct() {
		$this->_observationAspectNameMap = new AOWP_Map();
	}
	
	private static function _getSerializationPath($isWeavingTime = false) {
		$fileName = 'AOWP_GeneratedAspectNameManager';
		return AOWP_ConfigurationManager::getRuntimeDataFolder() . $fileName;
	}
	
	public static function reflesh() {
		AOWP_GeneratedAspectNameManager::_releaseInstance(new AOWP_GeneratedAspectNameManager());
	}
	
	private static function _getInstance($isWeavingTime = false) {
		if (AOWP_GeneratedAspectNameManager::$_instance === null) {
			$serializationPath = AOWP_GeneratedAspectNameManager::_getSerializationPath($isWeavingTime);
			if (!file_exists($serializationPath)) {
				$observationFactoryInstance = new AOWP_GeneratedAspectNameManager();
				file_put_contents($serializationPath, serialize($observationFactoryInstance));
				AOWP_GeneratedAspectNameManager::$_instance = $observationFactoryInstance;
				return $observationFactoryInstance;
			}
			else {
				$observationFactoryInstance = unserialize(file_get_contents($serializationPath));
				AOWP_GeneratedAspectNameManager::$_instance = $observationFactoryInstance;
				return $observationFactoryInstance;
			}
		}
		else {
			return AOWP_GeneratedAspectNameManager::$_instance;
		}
	}
	private static function _releaseInstance($observationAspectInstance) {
		file_put_contents(AOWP_GeneratedAspectNameManager::_getSerializationPath(true), serialize($observationAspectInstance));
	}
	
	public static function getGeneratedAspectName($richPointcutInstance) {
		$observationAspectInstance = AOWP_GeneratedAspectNameManager::_getInstance(true);
		$generatedAspectName = $observationAspectInstance->_observationAspectNameMap->get($richPointcutInstance);
		if ($generatedAspectName !== null) {
			return $generatedAspectName;
		}
		else {
			$generatedAspectName = 'AOWP_' . uniqid() . '_GeneratedAspect';
			$observationAspectInstance->_observationAspectNameMap->put($richPointcutInstance, $generatedAspectName);
			AOWP_GeneratedAspectNameManager::_releaseInstance($observationAspectInstance);
			return $generatedAspectName;
		}
	}
	
}
?>