<?php
/**
 * GlobalVariableSetPointcut.class
 */
class AOWP_GlobalVariableSetPointcut extends AOWP_Pointcut {
	private $_variableName;
	
	/**
	 * Constructor.
	 */
    public function __construct ($valName) 
    {
    	$this->_variableName = $valName;
    }
    
    public function specificMatch(AOWP_JoinPoint $joinPoint)
	{
		return 
		( 
			get_class($joinPoint)==AOWP_GlobalVariableSetJoinPoint &&
			AOWP_PointcutMatcher::match($this->_variableName, $joinPoint->getVariableName())
		);
	}
	
	public function runtimeSpecificMatch(AOWP_Context $context) 
	{
		return true;
	}
}
?>