<?php
/**
 * MethodCallPointcut
 *
 * @package aowp.aspect.pointcut
 */
class AOWP_MethodCallPointcut extends AOWP_Pointcut {
	private $_className;
	private $_methodName;
	private $_argumentScount;

	/**
	 * Constructor.
	 */
	public function __construct ($className, $methodName, $argumentsCount)
	{
		$this->_className      = $className;
		$this->_methodName     = $methodName;
		$this->_argumentsCount = $argumentsCount;
	}
	
	public function specificMatch(AOWP_JoinPoint $joinPoint)
	{
		return 
		( 
			get_class($joinPoint)==AOWP_MethodCallJoinPoint) &&
			AOWP_PointcutMatcher::match($this->_methodName, $joinPoint->getMethodName()) &&
			(($this->_argumentsCount == -1) || ($this->_argumentsCount == $joinPoint->getArgumentsCount())
		);
	}
	
	public function runtimeSpecificMatch(AOWP_Context $context) 
	{
		return AOWP_PointcutMatcher::match($this->_className, get_class($context->instance));
	}
}
?>
