<?php
/**
 * MethodExecutionPointcut.class
 * 
 * @package aowp.aspect.pointcut
 */
class AOWP_MethodExecutionPointcut extends AOWP_Pointcut {
	private $_modifiers;
	private $_className;
	private $_methodName;
	private $_argumentsCount;

	/**
	 * Constructor.
	 */
	public function __construct ($modifiers, $className, $methodName, $argumentsCount) 
	{
		$this->_modifiers      = $modifiers;
		$this->_className      = $className;
		$this->_methodName     = $methodName;
		$this->_argumentsCount = $argumentsCount;
	}

	public function specificMatch(AOWP_JoinPoint $joinPoint)
	{
		return 
		(
			get_class($joinPoint)==AOWP_MethodExecutionJoinPoint &&
			AOWP_PointcutMatcher::match($this->_modifiers, $joinPoint->getModifiers()) &&
			AOWP_PointcutMatcher::match($this->_className, $joinPoint->getClassName()) &&
			AOWP_PointcutMatcher::match($this->_methodName, $joinPoint->getMethodName()) &&
			(($this->_argumentsCount==-1) || ($this->_argumentsCount==$joinPoint->getArgumentsCount()))
		);
	}
	
	public function runtimeSpecificMatch(AOWP_Context $context) 
	{
		return true;
	}
}
?>
