<?php
/**
 * Pointcut.class
 * 
 * @package aowp.aspect.pointcut
 */
abstract class AOWP_Pointcut {
	private $_notFlag = false;
	private $_orPointcutArray = array();
	private $_andPointcutArray = array();
	
	abstract public function specificMatch(AOWP_JoinPoint $joinPoint);
	abstract public function runtimeSpecificMatch(AOWP_Context $context);
	
	public function setNotFlag() 
	{
		$this->_notFlag = true;
	}
	
	public function unsetNotFlag()
	{
		$this->_notFlag = false;
	}
	
	public function isNotPointcut() 
	{
		return $this->_notFlag;
	}
	public function getAndPointcutArray() {
		return $this->_andPointcutArray;
	}
	public function getOrPointcutArray() {
		return $this->_orPointcutArray;
	}
	public function addAnd(AOWP_Pointcut $pointcut) 
	{
		$this->_andPointcutArray[] = $pointcut;
	}
	
	public function addOr(AOWP_Pointcut $pointcut) 
	{
		$this->_orPointcutArray[] = $pointcut;
	}
	
	public function Not() 
	{
		if ($this->isNotPointcut()) {
			$this->unsetNotFlag();
		} else {
			$this->setNotFlag();
		}
		
		if ($this->_isAndPointcutSet()) {
			foreach ($this->_addPointcutArray as $pointcut) {
				if ($pointcut->isNotPointcut()) {
					$pointcut->unsetNotFlag();
				} else {
					$pointcut->setNotFlag();
				}
			}
		}
		
		if ($this->_isOrPointcutSet()) {
			foreach ($this->_orPointcutArray as $pointcut) {
				if ($pointcut->isNotPointcut()) {
					$pointcut->unsetNotFlag();
				} else {
					$pointcut->setNotFlag();
				}
			}
		 }
	}
	
	public function isSpecificMatch($joinPoint)
	{
		if ($this->specificMatch($joinPoint)) {
			return $this->isRuntimePointcut() || !$this->isNotPointcut();
		}
		else {
			return !$this->isRuntimePointcut() && $this->isNotPointcut();
		}
	}
	
	public function isRuntimePointcut() {
		return in_array('AOWP_RuntimePointcut', class_implements($this));
	}
	
	public function match(AOWP_JoinPoint $joinPoint) 
	{
		if (!$this->_isAndPointcutSet() && !$this->_isOrPointcutSet()) {
			return $this->isSpecificMatch($joinPoint);
		}
		
		$res = $this->isSpecificMatch($joinPoint);
		foreach ($this->_orPointcutArray as $pointcut) {
			$res = $res || ($pointcut->match($joinPoint));
		}
		foreach ($this->_andPointcutArray as $pointcut) {
			$res = $res && ($pointcut->match($joinPoint));
		}
		
		return $res;
	}
	
	public function isRuntimeSpecificMatch($context)
	{
		$res = true;
		if (!$this->isNotPointcut() && !$this->runtimeSpecificMatch($context)) {
			$res = false;
		}
		if ($this->isNotPointcut() && $this->runtimeSpecificMatch($context)) {
			$res = false;
		} 
		return $res;
	}
	
	public function runtimeMatch(AOWP_Context $context)
	{
		if (!$this->_isAndPointcutSet() && !$this->_isOrPointcutSet()) {
			if (!$this->isNotPointcut() && !$this->runtimeSpecificMatch($context)) {
				return false;
			}
			if ($this->isNotPointcut() && $this->runtimeSpecificMatch($context)) {
				return false;
			}
			return true;
		}
		
		$res = $this->isRuntimeSpecificMatch($context);
		if ($this->_isOrPointcutSet()) {
			foreach ($this->_orPointcutArray as $pointcut) {
				$res = $res || ($pointcut->runtimeMatch($context));
			}
		}
		if ($this->_isAndPointcutSet()) {
			foreach ($this->_andPointcutArray as $pointcut) {
				$res = $res && ($pointcut->runtimeMatch($context));
			}
		}
		
		return $res;
	}
	
	private function _isAndPointcutSet() 
	{
		return count($this->_andPointcutArray) > 0;
	}
	
	private function _isOrPointcutSet() 
	{
		return count($this->_orPointcutArray) > 0;
	}
}
?>
