<?php
/**
 * 
 * @package aowp.aspect.pointcut
 */
/**
 * 
 * @package aowp.aspect.pointcut
 */
class AOWP_RequestPointcut extends AOWP_Pointcut implements AOWP_RuntimePointcut {
	
	private $_urlPattern;
	private $_formDataArray;
	private $_headerArray;
	
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $urlPattern プロジェクトのルートフォルダに対応するURLを/として記述
	 * @param array $formDataArray フォームデータの名前と値のパターン (mb_ereg)から成る連想配列
	 * @param array $headerArray ヘッダーの名前と値のパターン (mb_ereg)から成る連想配列。ヘッダーの名前は、$_SERVERと対応づけて記述。
	 */
	public function __construct($urlPattern, array $formDataArray = array(), array $headerArray = array()) {
		$this->_urlPattern = $urlPattern;
		$this->_formDataArray = $formDataArray;
		$this->_headerArray = $headerArray;
	}
	
	public function specificMatch(AOWP_JoinPoint $joinPoint) {
		if ($joinPoint instanceof AOWP_ScriptExecutionJoinPoint) {
			return $this->requestURLMatch($joinPoint->getScriptName());
		}
		else {
			return false;
		}
	}
	public function isSpecificMatch(AOWP_JoinPoint $joinPoint) {
		if ($joinPoint instanceof AOWP_ScriptExecutionJoinPoint) {
			if (!$this->isNotPointcut()) {
				return $this->specificMatch($joinPoint);
			}
			else {
				if (count($this->getAndPointcutArray()) == 0 && count($this->getOrPointcutArray()) == 0) {
					return !$this->specificMatch($joinPoint);
				}
				else {
					return true;
				}
			}
		}
	}
	
	public function requestURLMatch($scriptPath) {
		return mb_ereg_match($this->_urlPattern, AOWP_RequestPointcut::_getRelativeURL($scriptPath));
	}
	
	private static function _getRelativeURL($sourcePath) {
		return substr($sourcePath, strlen(AOWP_Configuration::PROJECT_HOME_PATH));
	}
	
	public function getURLPattern() {
		return $this->_urlPattern;
	}
	public function getFormDataArray() {
		return $this->_formDataArray;
	}
	public function getHeaderArray() {
		return $this->_headerArray;
	}

	public function runtimeSpecificMatch(AOWP_Context $context) {
		foreach ($this->_formDataArray as $formDataName => $formDataValue) {
			if (!mb_ereg_match($formDataValue, $_REQUEST[$formDataName])) {
				return false;
			}
		}
		foreach ($this->_headerArray as $headerName => $headerValue) {
			if (!mb_ereg_match($headerValue, $_SERVER[$headerName])) {
				return false;
			}
		}
		return true;
	}
}
?>