<?php
/**
 * ScriptCallPointcut.class
 * 
 * @package aowp.aspect.pointcut
 */
class AOWP_ScriptCallPointcut extends AOWP_Pointcut {
	private $_scriptName;
	
	/**
	 * Constructor.
	 */
	public function __construct ($scriptName) 
	{
		parent::__construct();
		$this->_scriptName = $scriptName;
	}
	
	public function specificMatch(AOWP_JoinPoint $joinPoint) 
	{
		return 
		(
			$joinPoint instanceof AOWP_ScriptCallJoinPoint) &&
			AOWP_PointcutMatcher::match($this->_scriptName, $joinPoint->getScriptName()
		);
	}

	public function runtimeSpecificMatch(AOWP_Context $context) 
	{
		return true;
	}
}
?>