<?php
/**
 * ScriptExecutionPointcut.class
 * 
 * @package aowp.aspect.pointcut
 */
class AOWP_ScriptExecutionPointcut extends AOWP_Pointcut {
	private $_scriptName;
	
	/**
	 * Constructor.
	 */
	public function __construct ($scriptName) 
	{
		$this->_scriptName = $scriptName;
	}
	
	public function specificMatch(AOWP_JoinPoint $joinPoint) 
	{
		return 
		(
			$joinPoint instanceof AOWP_ScriptExecutionJoinPoint) &&
			AOWP_PointcutMatcher::match($this->_scriptName, $joinPoint->getScriptName()
		);
	}

	public function runtimeSpecificMatch(AOWP_Context $context) 
	{
		return true;
	}
}
?>