<?php
/**
 * WithincodePointcut.class
 * 
 * @package aowp.aspect.pointcut
 */
class AOWP_WithincodePointcut extends AOWP_Pointcut {
    private $_modifiers;
	private $_className;
	private $_methodName;
	private $_argumentsCount;
	
	/**
	 * Constructor.
	 */
    public function __construct ($modifiers, $className, $methodName, $argumentsCount) 
	{
		parent::__construct();
		$this->_modifiers      = $modifiers;
		$this->_className      = $className;
		$this->_methodName     = $methodName;
		$this->_argumentsCount = $argumentsCount;
	}
   
    public function specificMatch(AOWP_JoinPoint $joinPoint)
    {
    	return 
    	(
    		AOWP_PointcutMatcher::match($this->_modifiers, $joinPoint->getBelongMethodModifiers()) &&
			AOWP_PointcutMatcher::match($this->_className, $joinPoint->getBelongClassName()) &&
			AOWP_PointcutMatcher::match($this->_methodName, $joinPoint->getBelongMethodName()) &&
			(($this->_argumentsCount==-1) || ($this->_argumentsCount==$joinPoint->getBelongMethodArgumentsCount()))
		);
    }

	public function runtimeSpecificMatch(AOWP_Context $context) 
	{
		return true;
	}
}
?>
