<?php
/**
 * 
 * @package aowp.aspect.pointcut.pagehistory
 */

/**
 * ページ遷移履歴を取り扱うポイントカット記述子。
 * 
 * @uses AOWP_RequestObserveAspect
 * @package aowp.aspect.pointcut.pagehistory
 */
class AOWP_PageHistoryPointcut extends AOWP_Pointcut implements AOWP_RuntimePointcut, AOWP_RichPointcut {
	
	private $_observeRequestArray;
	private $_historyJustBeforeFlag;
	
	/**
	 * コンストラクタ
	 *
	 * @param string $uniqueName 履歴保存用のアスペクトの名前の定義に利用する。他のPageHistoryPointcutと重複しない名前をつける必要が有る。 
	 * @param array $observeRequestArray 監視に利用するページ遷移のパターンを表すRequestPointcutの配列。
	 * @param boolean $historyJustBeforeFlag 指定したページ遷移の履歴が直前の履歴である必要がある場合trueにする。
	 */
	public function __construct($observeRequestArray = array(), $historyJustBeforeFlag = false) {
		$this->_observeRequestArray = $observeRequestArray;
		$this->_historyJustBeforeFlag = $historyJustBeforeFlag;
	}
	public function generateAspect() {
		$generatedAspectName = AOWP_GeneratedAspectNameManager::getGeneratedAspectName($this);
		AOWP_AspectManager::saveWeaverGenerateAspect(
			$generatedAspectName,
			AOWP_RequestObserveAspect::getRequestObserveAspectSource($generatedAspectName, $this->_observeRequestArray, $this->_historyJustBeforeFlag));
	}
	
	public function addRequest(AOWP_RequestPointcut $requestPointcut, $iteration = 1) {
		for ($i = 0; $i < $iteration; $i++) {
			$this->_observeRequestArray[] = $requestPointcut;
		}
	}
	public function setHistoryJustBeforeFlag($historyJustBeforeFlag) {
		$this->_historyJustBeforeFlag = $historyJustBeforeFlag;
	}
	
	public static function getContext($contextIndex) {
		$observeAspect = AOWP_AspectInstanceManager::getInstance(AOWP_GeneratedAspectNameManager::getGeneratedAspectName($this));
		return $observeAspect->getHistoryContext($contextIndex);
	}
	
	public function specificMatch(AOWP_JoinPoint $joinPoint) {
		return true;
	}
	public function runtimeSpecificMatch(AOWP_Context $context) {
		$observeAspect = AOWP_AspectInstanceManager::getInstance(AOWP_GeneratedAspectNameManager::getGeneratedAspectName($this));
		return $observeAspect->isHistoryMatch();
	}
		
}
?>