<?php
/**
 * 
 * @package aowp.aspect.pointcut.pagehistory
 */

/**
 * 設定したページ遷移の履歴が存在するか否かを管理するアスペクト。
 *
 * @package aowp.aspect.pointcut.pagehistory
 */
class AOWP_RequestObserveAspect extends AOWP_PerSessionAspect {
	
	private $_contextArray = array();
	private $_requestPointcutArray = array();
	private $_observationIndex = 0;
	private $_observationResult = false;
	private $_historyJustBeforeFlag = false;
	
	public function __construct() {
		$observationAdvice = new AOWP_BeforeAdvice();
		$observationAdvice->setAdviceBody('observe', $this);
		$observationAdvice->setPointcut(new AOWP_RequestPointcut('.*', array(), array()));
		$this->addAdvice($observationAdvice);
	}
	
	public function getObservationIndex() {
		return $this->_observationIndex;
	}
	
	public function isHistoryMatch() {
		return $this->_observationResult;
	}
	private function _resetObservation() {
		$this->_observationIndex = 0;
		$this->_contextArray = array();
	}
	
	public function addObserveRequest(AOWP_RequestPointcut $requestPointcut) {
		$this->_requestPointcutArray[] = $requestPointcut;
	}
	
	public function getHistoryContext($historyIndex) {
		return isset($this->_contextArray[$historyIndex]) ? $this->_contextArray[$historyIndex] : null;
	}
	
	public function observe(AOWP_ContextOfScriptExecution $context) {
		if (!$this->_historyJustBeforeFlag && $this->_observationResult) {

		}
		else {
			if ($this->_match($this->_requestPointcutArray[$this->_observationIndex], $context)) {
				$this->_observationIndex++;
				$this->_contextArray[$this->_observationIndex] = $context;		
				if ($this->_observationIndex == count($this->_requestPointcutArray)) {
					$this->_observationResult = true;
					$this->_resetObservation();
				}
				else {
					$this->_observationResult = false;
				}
			}
			else {
				$this->_resetObservation();
				$this->_observationResult = false;
			}
		}
	}
	private function _match(AOWP_RequestPointcut $requestPointcut, AOWP_ContextOfScriptExecution $context) {
		return $requestPointcut->requestURLMatch($context->scriptName) && $requestPointcut->runtimeSpecificMatch($context);
	}
	
	/**
	 * ページ遷移履歴を管理する為のAOPW_RequestObservationAspectのサブクラスの定義を動的に生成する。
	 *
	 * @param string $aspectName アスペクトのクラス名
	 * @param array $observeRequestArray 
	 * @param string $historyJustBeforeFlag
	 */
	public static function getRequestObserveAspectSource($aspectName, array $observeRequestArray, $historyJustBeforeFlag) {
		$classDefineSource;
		$classDefineSource .= ('<?php' . "\n");
		$classDefineSource .= ('class ' . $aspectName . ' extends AOWP_RequestObserveAspect {' . "\n");
		$classDefineSource .= ('public function __construct() {' . "\n");
		$classDefineSource .= ('parent::__construct();' . "\n");
		foreach ($observeRequestArray as $observeRequest) {
			$classDefineSource .= ('$this->addObserveRequest(' . AOWP_RequestObserveAspect::_requestPointcut2Source($observeRequest) . ');' . "\n");
		}
		if ($historyJustBeforeFlag) {
			$classDefineSource .= ('$this->_historyJustBeforeFlag = true;' . "\n");
		}
		$classDefineSource .= ('}' . "\n");
		$classDefineSource .= ('}' . "\n");
		$classDefineSource .= ('?>' . "\n");
		return $classDefineSource;
	}
	private static function _requestPointcut2Source(AOWP_RequestPointcut $requestPointcut) {
		$pointcutInstanceSource;
		$pointcutInstanceSource .= ('new AOWP_RequestPointcut("' . $requestPointcut->getURLPattern() . '", ');
		$pointcutInstanceSource .= ('array(');
		$addedFormDataFlag = false;
		foreach ($requestPointcut->getFormDataArray() as $formDataName => $formDataValue) {
			if (!$addedFormDataFlag) {
				$addedFormDataFlag = true;
			}
			else {
				$pointcutInstanceSource .= (', ');
			}
			$pointcutInstanceSource .= ('"' . $formDataName . '" => "' . $formDataValue . '"');
		}
		$pointcutInstanceSource .= ('), ');
		$pointcutInstanceSource .= ('array(');
		$addedHeaderFlag = false;
		foreach ($requestPointcut->getHeaderArray() as $headerName => $headerValue) {
			if (!$addedHeaderFlag) {
				$addedHeaderFlag = true;
			}
			else {
				$pointcutInstanceSource .= (', ');
			}
			$pointcutInstanceSource .= ('"' . $headerName . '" => "' . $headerValue . '"');
		}
		$pointcutInstanceSource .= (')');
		$pointcutInstanceSource .= (')');
		$andPointcutArray = $requestPointcut->getAndPointcutArray();
		$orPointcutArray = $requestPointcut->getOrPointcutArray();
		if (count($andPointcutArray) > 0) {
			foreach ($andPointcutArray as $pointcut) {
				$pointcutInstanceSource .= ('->addAnd(' . AOWP_RequestObserveAspect::_requestPointcut2Source($pointcut) . ')');
			}
		}
		else if (count($orPointcutArray) > 0) {
			foreach ($orPointcutArray as $pointcut) {
				$pointcutInstanceSource .= ('->orAnd(' . AOWP_RequestObserveAspect::_requestPointcut2Source($pointcut) . ')');
			}
		}
		return $pointcutInstanceSource;
	}
}
?>