<?php
/**
 * Enter description here...
 * @package aowp.aspect.weaver
 */
class AOWP_PHPFileManager {
	
	private static $_PHP_FILE_NAME_ARRAY = null;
	
	/**
	 * 指定したフォルダ配下の全てのPHPファイルのフルパスを返します。
	 *
	 * @param unknown_type $directoryPath 織り込み対象のプロジェクトのルートフォルダ。無しの時は、AOWP_PHPFileManager::BASE_PATHが使われる。
	 * @return unknown
	 */
	private static function _getAllPHPFile($directoryPath, $includePattern = null){
		$phpFileNameArray = array();
		if ($directoryPath != AOWP_Configuration::RUNTIME_DATA_FOLDER) {
			$directory = dir($directoryPath);
			while (($fileName = $directory->read()) !== false) {
				if ($fileName == '.' || $fileName == '..') {
					
				}
				else if ($fileName == AOWP_ConfigurationManager::getCacheFolder()) {
					
				}
				else if (AOWP_Configuration::EXCLUDE_PHP_FILE_PATERN != '' &&
					preg_match(AOWP_Configuration::EXCLUDE_PHP_FILE_PATERN, $fileName)) {
					
				}
				else if (is_dir($directoryPath . DIRECTORY_SEPARATOR . $fileName)) {
					$phpFileNameArray = array_merge($phpFileNameArray, AOWP_PHPFileManager::_getAllPHPFile($directoryPath . DIRECTORY_SEPARATOR . $fileName, $includePattern));
				}
				else if (preg_match(AOWP_Configuration::INCLUDE_PHP_FILE_PATERN, $fileName) &&
					($includePattern === null || preg_match($includePattern, $fileName))) {
					$phpFileNameArray[] = $directory->path . DIRECTORY_SEPARATOR . $fileName;
				}
			}
		}
		return $phpFileNameArray;
	}
	
	public static function getAllAspectPHPFile() {
		return AOWP_PHPFileManager::_getAllPHPFile(AOWP_Configuration::ASPECT_DIR_PATH, '/Aspect\.class\.php$/');
	}
	
	public static function getAllProjectPHPFile(){
		return AOWP_PHPFileManager::_getAllPHPFile(AOWP_Configuration::PROJECT_HOME_PATH);
	}
		
	private static function _getBackupPath() {
		return AOWP_Configuration::PROJECT_HOME_PATH . '.org';
	}
	
	private static function _isWindows() {
		return strtoupper(substr(PHP_OS, 0, 3)) === 'WIN';
	}
	
	public static function removeFolder($path) {
		if (AOWP_PHPFileManager::_isWindows()) {
			system("rmdir $path /s /q");
		}
		else {
 			system("rm -rf $path");
		}
	}
	
	public static function mkdir($path) {
		mkdir($path, 0777, true);
		if (!AOWP_PHPFileManager::_isWindows()) {
			system("chmod -R 777 $path");
		}
	}
	
	public static function copy($src, $dist) {
		if (AOWP_PHPFileManager::_isWindows()) {
//			system("xcopy $src $dist /E /Y");
			full_copy($src, $dist);
	}
		else {
			system("cp -Rf $src $dist");
			system("chmod -R 777 $dist");
		}
	}
	
	public static function move($src, $dist) {
		if (AOWP_PHPFileManager::_isWindows()) {
			system("move $src $dist");
		}
		else {
			system("mv $src $dist");
			system("chmod -R 777 $dist");
		}
	}
	
	public static function backupOriginalPHPFile() {
		if (!file_exists(AOWP_PHPFileManager::_getBackupPath())) {
			AOWP_PHPFileManager::copy(AOWP_Configuration::PROJECT_HOME_PATH, AOWP_PHPFileManager::_getBackupPath());
		}
	}
	
	public static function undoWeaving() {
		if (file_exists(AOWP_PHPFileManager::_getBackupPath())) {
			AOWP_PHPFileManager::removeFolder(AOWP_Configuration::PROJECT_HOME_PATH);
			AOWP_PHPFileManager::move(AOWP_PHPFileManager::_getBackupPath(), AOWP_Configuration::PROJECT_HOME_PATH);
		}
	}
	
}


/**
 * http://php.mirror.camelnetwork.com/manual/ja/function.copy.php
 * swizec@swizec.com
 */
function full_copy( $source, $target )
    {
        if ( is_dir( $source ) )
        {
            @mkdir( $target );
           
            $d = dir( $source );
           
            while ( FALSE !== ( $entry = $d->read() ) )
            {
                if ( $entry == '.' || $entry == '..' )
                {
                    continue;
                }
               
                $Entry = $source . '/' . $entry;           
                if ( is_dir( $Entry ) )
                {
                    full_copy( $Entry, $target . '/' . $entry );
                    continue;
                }
                copy( $Entry, $target . '/' . $entry );
            }
           
            $d->close();
        }else
        {
            copy( $source, $target );
        }
    }
?>