<?php
/**
 * Enter description here...
 *
 * @package aowp.aspect.weaver
 */

/**
 * Enter description here...
 *
 * @package aowp.aspect.weaver
 */
class AOWP_Weaver {
	
	private $_RemainingAspectTasks = array();
	private $_allChachedASTFileNameArray = array();
	private $_RemainingASTTasks = array();
	private $_nowWeavingAspect = null;
	
	const SERIARIZE_FILENAME = 'AOWP_Weaver';
	
	public function __construct() {
		AOWP_AspectManager::clearCache();
		AOWP_AspectManager::loadUserDefineAspect();
		$this->_allChachedASTFileNameArray = AOWP_ASTManager::getAllCachedASTFileName();
		AOWP_Logger::logging('[Weaver] ' . count($this->_allChachedASTFileNameArray) . ' cached AST');
		AOWP_AspectManager::refleshWeaverGenerateAspect();
		AOWP_GeneratedAspectNameManager::reflesh();
		foreach (AOWP_AspectManager::getAllAspects() as $aspect) {
			$aspect->generateAspect();
		}
		$this->_RemainingAspectTasks = AOWP_AspectManager::getAllAspects();
		AOWP_Logger::logging('[Weaver] ' . count($this->_RemainingAspectTasks) . ' aspects');
	}
	
	public function getRemainingAspectTaskNum() {
		return count($this->_RemainingAspectTasks);
	}
	public function getRemainingASTTaskNum() {
		return count($this->_RemainingASTTasks);
	}
	public function getAllASTNum() {
		return count($this->_allChachedASTFileNameArray);
	}
	
	public function weaveNext() {
		if (count($this->_RemainingASTTasks) === 0) {
			$this->_RemainingASTTasks = $this->_allChachedASTFileNameArray;
			$this->_nowWeavingAspect = array_shift($this->_RemainingAspectTasks);
			$aspect = $this->_nowWeavingAspect;
			AOWP_Logger::logging('[Weave] Now ' . get_class($this->_nowWeavingAspect) . ' is woven');
			$cachedASTFileName = array_shift($this->_RemainingASTTasks);
		}
		else {
			$cachedASTFileName = array_shift($this->_RemainingASTTasks);
			$aspect = $this->_nowWeavingAspect;
		}	
		AOWP_Logger::setStartTime(2);
		$parseResult = AOWP_ASTManager::getWovenASTFile($cachedASTFileName);
		if ($parseResult !== null && isset($parseResult->root)) {
			$this->weaveAspectToOnePHPFile($parseResult->root, $aspect, AOWP_ASTManager::getSourcePath($cachedASTFileName));
			AOWP_ASTManager::saveWeaveCache($cachedASTFileName, $parseResult);
			AOWP_Logger::logging('[Weave] Weave ' . $cachedASTFileName, 2);
		}
		else {
			AOWP_Logger::logging('[Weave] Failed to weave ' . $cachedASTFileName, 2);
			exit();
		}
		$parseResult->root->releaseInstance();
		return array(get_class($aspect), $cachedASTFileName);
	}
	
	public function weaveAllAspect(){
		AOWP_ASTManager::refleshWovenAST();
		AOWP_Logger::logging('[Weave] Reflesh cached woven AST');
		while (!$this->isEndWeaving()) {
			$this->weaveNext();
		}
	}
	
	public function isEndWeaving() {
		return ($this->_RemainingAspectTasks === array()) && ($this->_RemainingASTTasks === array());
	}
	
	public function seriarize(){
		$serializeFilePath = $this->getSerializeFilePath();
		$seriarizeContent = serialize($this);
		file_put_contents($serializeFilePath, $seriarizeContent);
	}
	
	public function getSerializeFilePath(){
		return AOWP_Configuration::WEAVING_DATA_DIR_PATH . '/' . AOWP_Weaver::SERIARIZE_FILENAME;
	}

	/**
	 * Weave all aspects to one PHP file.
	 *
	 * @param string $file Path of taretedPHP file.
	 * @param array $allAspect All instances of aspects.
	 */
	public static function weaveAspectToOnePHPFile(AOWP_PHPRootElement $rootAST, $aspect, $filePath) {
		$arrayForASTWalk = AOWP_ASTWalker::getASTArrayForWalk($rootAST);
		foreach ($arrayForASTWalk as $ast) {
			$joinPoint = AOWP_JoinPointCreator::createJoinPoint($ast, $filePath);
			if ($joinPoint != null) {
				$aspect->weave($joinPoint);
			}
		}
	}
}
?>