<?php
/**
 * Enter description here...
 *
 * @package aowp.parser.ast
 */

/**
 * PHPElement
 *
 * PHPの文法要素のインターフェイス
 * 文法規則: unticked_class_declaration_statement
 *
 * @package aowp.parser.ast
 * @access  public
 * @author  Ryoto Naruse <naruse@minnie.ai.kyutech.ac.jp>
 *
 */
class AOWP_PHPElement
{
	private 	$parent = null;
	private 	$propertyName = '';
	private 	$propertyIndex = -1;
	private 	$_line = 0;
	
	//getParentPropertyIndexの戻り値
	//配列ではないことをあらわす
	const NO_ARRAY = -1;
	
	protected function initialize($_line){
		//行番号
		$this->_line = $_line;
		
		//それぞれの要素に親を設定
		foreach(get_object_vars($this) as $varName => $property) {
			if (AOWP_ASTUtility::isArrayElement($property)){
				for($i = 0; $i < count($property); $i++){
					if(AOWP_ASTUtility::isASTElement($property[$i])){
						$property[$i]->setParentInfo($this, $varName, $i);
					}
				}
			}
			else if (AOWP_ASTUtility::isASTElement($property)){
				$property->setParentInfo($this, $varName);
			}
		}		
	}
	public function setParentInfo($parent, $propertyName = '', $propertyIndex = NO_ARRAY){
		$this->parent 			= $parent;
		$this->propertyName		= $propertyName;
		$this->propertyIndex 	= $propertyIndex;
	}
	public function line(){
		return $this->_line;
	}
	public function __toString(){
		return "";
	}
	public function kind(){
		return "element";
	}
	public function getParent() {
		return $this->parent;
	}
	public function getParentPropertyName(){
		return $this->parentName;
	}
	public function getParentPropertyIndex(){
		return $this->propertyIndex;
	}
	public function getChildrenForWalk() {
		$ret = array();
		//配列とobjectのプロパティをまとめてひとつの配列にする
		foreach(get_object_vars($this) as $varName => $property) {
			if ($varName != 'parent') {
				if (AOWP_ASTUtility::isArrayElement($property)){
					foreach($property as $propertyInArray){
						if(AOWP_ASTUtility::isASTElement($propertyInArray)){
							$ret[] = $propertyInArray;
						}
					}
				}
				else if (AOWP_ASTUtility::isASTElement($property)){
					$ret[] = $property;
				}
			}
		}
		return $ret;
	}
	public function releaseInstance() {
		foreach(get_object_vars($this) as $varName => $property) {
			if (AOWP_ASTUtility::isArrayElement($property)){
				foreach($property as $propertyInArray){
					if(AOWP_ASTUtility::isASTElement($propertyInArray)){
						$propertyInArray->releaseInstance();
					}
				}
			}
			else if (AOWP_ASTUtility::isASTElement($property) && $varName != 'parent') {
				$property->releaseInstance();
			}
			$this->$varName = null;
		}
	}
}
?>