<?php
include_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'AccessManager.class.php';

class AccessControllAspect extends AOWP_PerSessionAspect {
	
	private $_loginName;
	
	public function __construct() {
		$this->_loginName = null;
		$advice = new AOWP_BeforeAdvice();
		$pointcut = new AOWP_RequestPointcut('.*');
		$advice->setPointcut($pointcut);
		$advice->setAdviceBody('accessCheck');
		$this->addAdvice($advice);
	}
	
	public function accessCheck(AOWP_Context $context) {
		$accessManager = new AccessManager();
		$name = $_POST['aowp_name'];
		$password = $_POST['aowp_password'];
		if ($this->_loginName !== null) {
		}
		else if ($accessManager->checkUser($name, $password)) {
			$this->_loginName = $name;
		}
		else {
			$toURL = $_SERVER['REQUEST_URI'];
			include dirname(__FILE__) . DIRECTORY_SEPARATOR . 'login.php';
			die();
		}
	}
}
?>