<?php

class LoggingPerUserAspect extends AOWP_PerSessionAspect {
	
	private $_logDirPath;
	
	public function __construct() {
		$this->_logDirPath = dirname( __FILE__ ) . DIRECTORY_SEPARATOR . "log" . DIRECTORY_SEPARATOR;	
		$this->_loginName = null;
		$advice = new AOWP_BeforeAdvice();
		$pointcut = new AOWP_RequestPointcut('.*index\.php');
		$advice->setPointcut($pointcut);
		$advice->setAdviceBody('logging');
		$this->addAdvice($advice);
	}
	
	public function logging(AOWP_Context $context) {
		$logfilepath = $this->_logDirPath . session_id() . ".log";
		if(file_exists($logfilepath)){
			$file = fopen($logfilepath, "a");
			fwrite($file, "[" . date("Y/m/d l H:i:s") . "]" . $_SERVER['REQUEST_URI'] . "\n");
			fclose($file);
		}
		else{
			file_put_contents($logfilepath, "[" . date("Y/m/d l H:i:s") . "]" . $_SERVER['REQUEST_URI'] . "\n");
		}
	}
}
?>